/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheSizeComputer;
import org.apache.tsfile.utils.RamUsageEstimator;

public class CacheEntryGroupImpl<FK, SK, V, T extends ICacheEntry<SK, V>>
implements ICacheEntryGroup<FK, SK, V, T> {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(CacheEntryGroupImpl.class) + RamUsageEstimator.shallowSizeOfInstance(AtomicLong.class) + RamUsageEstimator.shallowSizeOfInstance(ConcurrentHashMap.class) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
    private final FK firstKey;
    private final Map<SK, T> cacheEntryMap = new ConcurrentHashMap<SK, T>();
    private final ICacheSizeComputer<FK, SK, V> sizeComputer;
    private final AtomicLong memory;

    CacheEntryGroupImpl(FK firstKey, ICacheSizeComputer<FK, SK, V> sizeComputer) {
        this.firstKey = firstKey;
        this.sizeComputer = sizeComputer;
        this.memory = new AtomicLong(INSTANCE_SIZE + (long)sizeComputer.computeFirstKeySize(firstKey));
    }

    @Override
    public FK getFirstKey() {
        return this.firstKey;
    }

    @Override
    public T getCacheEntry(SK secondKey) {
        return (T)(secondKey == null ? null : (ICacheEntry)this.cacheEntryMap.get(secondKey));
    }

    @Override
    public Iterator<Map.Entry<SK, T>> getAllCacheEntries() {
        return this.cacheEntryMap.entrySet().iterator();
    }

    @Override
    public T computeCacheEntry(SK secondKey, Function<AtomicLong, BiFunction<SK, T, T>> computation) {
        return (T)((ICacheEntry)this.cacheEntryMap.compute(secondKey, computation.apply(this.memory)));
    }

    @Override
    public long removeCacheEntry(SK secondKey) {
        ICacheEntry result = (ICacheEntry)this.cacheEntryMap.remove(secondKey);
        if (Objects.nonNull(result)) {
            long delta = (long)(this.sizeComputer.computeSecondKeySize(result.getSecondKey()) + this.sizeComputer.computeValueSize(result.getValue())) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
            this.memory.addAndGet(-delta);
            return delta;
        }
        return 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.cacheEntryMap.isEmpty();
    }

    @Override
    public long getMemory() {
        return this.memory.get();
    }

    @Override
    public int getEntriesCount() {
        return this.cacheEntryMap.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEntryGroupImpl that = (CacheEntryGroupImpl)o;
        return Objects.equals(this.firstKey, that.firstKey);
    }

    public int hashCode() {
        return this.firstKey.hashCode();
    }
}

