/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ternary.TernaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.BytesUtils;

public class SubString3ColumnTransformer
extends TernaryColumnTransformer {
    public SubString3ColumnTransformer(Type returnType, ColumnTransformer firstColumnTransformer, ColumnTransformer secondColumnTransformer, ColumnTransformer thirdColumnTransformer) {
        super(returnType, firstColumnTransformer, secondColumnTransformer, thirdColumnTransformer);
    }

    @Override
    protected void checkType() {
    }

    @Override
    protected void doTransform(Column firstColumn, Column secondColumn, Column thirdColumn, ColumnBuilder builder, int positionCount) {
        Type firstType = this.firstColumnTransformer.getType();
        Type secondType = this.secondColumnTransformer.getType();
        Type thirdType = this.thirdColumnTransformer.getType();
        for (int i = 0; i < positionCount; ++i) {
            if (!(firstColumn.isNull(i) || secondColumn.isNull(i) || thirdColumn.isNull(i))) {
                this.transform(firstColumn, secondColumn, thirdColumn, builder, firstType, secondType, thirdType, i);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column firstColumn, Column secondColumn, Column thirdColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        Type firstType = this.firstColumnTransformer.getType();
        Type secondType = this.secondColumnTransformer.getType();
        Type thirdType = this.thirdColumnTransformer.getType();
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i] && !firstColumn.isNull(i) && !secondColumn.isNull(i) && !thirdColumn.isNull(i)) {
                this.transform(firstColumn, secondColumn, thirdColumn, builder, firstType, secondType, thirdType, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(Column firstColumn, Column secondColumn, Column thirdColumn, ColumnBuilder builder, Type firstType, Type secondType, Type thirdType, int i) {
        int minMax;
        String currentValue = firstType.getBinary(firstColumn, i).getStringValue(TSFileConfig.STRING_CHARSET);
        int beginPosition = secondType.getInt(secondColumn, i);
        int length = thirdType.getInt(thirdColumn, i);
        if (length < 0) {
            throw new SemanticException("Argument exception,the scalar function substring length must not be less than 0");
        }
        int endPosition = beginPosition > Integer.MAX_VALUE - length ? Integer.MAX_VALUE : beginPosition + length - 1;
        if (beginPosition > currentValue.length()) {
            throw new SemanticException("Argument exception,the scalar function substring beginPosition must not be greater than the string length");
        }
        int maxMin = Math.max(1, beginPosition);
        currentValue = maxMin > (minMax = Math.min(currentValue.length(), endPosition)) ? "" : currentValue.substring(maxMin - 1, minMax);
        builder.writeBinary(BytesUtils.valueOf((String)currentValue));
    }
}

