/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl.values;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PreciseFilter
extends SchemaFilter {
    private final String value;

    public PreciseFilter(String value) {
        this.value = value;
    }

    public PreciseFilter(ByteBuffer byteBuffer) {
        this.value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <C> Boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitPreciseFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.PRECISE;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.value, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreciseFilter that = (PreciseFilter)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

