/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.JavaUtils;

public class FileListSnapshotInfo
implements SnapshotInfo {
    private final TermIndex termIndex;
    private final List<FileInfo> files;

    public FileListSnapshotInfo(List<FileInfo> files, TermIndex termIndex) {
        this.termIndex = termIndex;
        this.files = Collections.unmodifiableList(new ArrayList<FileInfo>(files));
    }

    public FileListSnapshotInfo(List<FileInfo> files, long term, long index) {
        this(files, TermIndex.valueOf((long)term, (long)index));
    }

    public TermIndex getTermIndex() {
        return this.termIndex;
    }

    public List<FileInfo> getFiles() {
        return this.files;
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + this.getTermIndex() + ":" + this.files;
    }
}

