/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.webpush;

import com.google.crypto.tink.apps.webpush.WebPushConstants;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.Hkdf;
import java.security.GeneralSecurityException;

class WebPushUtil {
    WebPushUtil() {
    }

    public static byte[] computeIkm(byte[] ecdhSecret, byte[] authSecret, byte[] uaPublic, byte[] asPublic) throws GeneralSecurityException {
        byte[] keyInfo = Bytes.concat((byte[][])new byte[][]{WebPushConstants.IKM_INFO, uaPublic, asPublic});
        return Hkdf.computeHkdf((String)"HMACSHA256", (byte[])ecdhSecret, (byte[])authSecret, (byte[])keyInfo, (int)32);
    }

    public static byte[] computeCek(byte[] ikm, byte[] salt) throws GeneralSecurityException {
        return Hkdf.computeHkdf((String)"HMACSHA256", (byte[])ikm, (byte[])salt, (byte[])WebPushConstants.CEK_INFO, (int)16);
    }

    public static byte[] computeNonce(byte[] ikm, byte[] salt) throws GeneralSecurityException {
        return Hkdf.computeHkdf((String)"HMACSHA256", (byte[])ikm, (byte[])salt, (byte[])WebPushConstants.NONCE_INFO, (int)12);
    }
}

