/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.Map;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.events.EventBusId;
import org.apache.james.events.NamingStrategy;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class KeyReconnectionHandler
implements SimpleConnectionPool.ReconnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyReconnectionHandler.class);
    private final NamingStrategy namingStrategy;
    private final EventBusId eventBusId;
    private final RabbitMQConfiguration configuration;

    @Inject
    public KeyReconnectionHandler(NamingStrategy namingStrategy, EventBusId eventBusId, RabbitMQConfiguration configuration) {
        this.namingStrategy = namingStrategy;
        this.eventBusId = eventBusId;
        this.configuration = configuration;
    }

    public Publisher<Void> handleReconnection(Connection connection) {
        return Mono.fromRunnable(() -> {
            try (Channel channel = connection.createChannel();){
                channel.queueDeclare(this.namingStrategy.queueName(this.eventBusId).asString(), true, false, true, (Map)this.configuration.workQueueArgumentsBuilder(true).build());
            }
            catch (Exception e) {
                LOGGER.error("Error recovering connection", (Throwable)e);
            }
        });
    }
}

