/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.v7;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.es.v7.IndexName;
import org.apache.james.backends.es.v7.ReadAliasName;
import org.apache.james.backends.es.v7.WriteAliasName;
import org.apache.james.mailbox.elasticsearch.v7.IndexAttachments;
import org.apache.james.mailbox.elasticsearch.v7.MailboxElasticSearchConstants;

public class ElasticSearchMailboxConfiguration {
    private static final String ELASTICSEARCH_INDEX_NAME = "elasticsearch.index.name";
    private static final String ELASTICSEARCH_INDEX_MAILBOX_NAME = "elasticsearch.index.mailbox.name";
    private static final String ELASTICSEARCH_ALIAS_READ_NAME = "elasticsearch.alias.read.name";
    private static final String ELASTICSEARCH_ALIAS_WRITE_NAME = "elasticsearch.alias.write.name";
    private static final String ELASTICSEARCH_ALIAS_READ_MAILBOX_NAME = "elasticsearch.alias.read.mailbox.name";
    private static final String ELASTICSEARCH_ALIAS_WRITE_MAILBOX_NAME = "elasticsearch.alias.write.mailbox.name";
    private static final String ELASTICSEARCH_INDEX_ATTACHMENTS = "elasticsearch.indexAttachments";
    private static final boolean DEFAULT_INDEX_ATTACHMENTS = true;
    public static final ElasticSearchMailboxConfiguration DEFAULT_CONFIGURATION = ElasticSearchMailboxConfiguration.builder().build();
    private final IndexName indexMailboxName;
    private final ReadAliasName readAliasMailboxName;
    private final WriteAliasName writeAliasMailboxName;
    private final IndexAttachments indexAttachment;

    public static Builder builder() {
        return new Builder();
    }

    public static ElasticSearchMailboxConfiguration fromProperties(Configuration configuration) {
        return ElasticSearchMailboxConfiguration.builder().indexMailboxName(ElasticSearchMailboxConfiguration.computeMailboxIndexName(configuration)).readAliasMailboxName(ElasticSearchMailboxConfiguration.computeMailboxReadAlias(configuration)).writeAliasMailboxName(ElasticSearchMailboxConfiguration.computeMailboxWriteAlias(configuration)).indexAttachment(ElasticSearchMailboxConfiguration.provideIndexAttachments(configuration)).build();
    }

    static Optional<IndexName> computeMailboxIndexName(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(ELASTICSEARCH_INDEX_MAILBOX_NAME)).map(IndexName::new).or(() -> Optional.ofNullable(configuration.getString(ELASTICSEARCH_INDEX_NAME)).map(IndexName::new));
    }

    static Optional<WriteAliasName> computeMailboxWriteAlias(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_WRITE_MAILBOX_NAME)).map(WriteAliasName::new).or(() -> Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_WRITE_NAME)).map(WriteAliasName::new));
    }

    static Optional<ReadAliasName> computeMailboxReadAlias(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_READ_MAILBOX_NAME)).map(ReadAliasName::new).or(() -> Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_READ_NAME)).map(ReadAliasName::new));
    }

    private static IndexAttachments provideIndexAttachments(Configuration configuration) {
        if (configuration.getBoolean(ELASTICSEARCH_INDEX_ATTACHMENTS, true)) {
            return IndexAttachments.YES;
        }
        return IndexAttachments.NO;
    }

    private ElasticSearchMailboxConfiguration(IndexName indexMailboxName, ReadAliasName readAliasMailboxName, WriteAliasName writeAliasMailboxName, IndexAttachments indexAttachment) {
        this.indexMailboxName = indexMailboxName;
        this.readAliasMailboxName = readAliasMailboxName;
        this.writeAliasMailboxName = writeAliasMailboxName;
        this.indexAttachment = indexAttachment;
    }

    public IndexName getIndexMailboxName() {
        return this.indexMailboxName;
    }

    public ReadAliasName getReadAliasMailboxName() {
        return this.readAliasMailboxName;
    }

    public WriteAliasName getWriteAliasMailboxName() {
        return this.writeAliasMailboxName;
    }

    public IndexAttachments getIndexAttachment() {
        return this.indexAttachment;
    }

    public final boolean equals(Object o) {
        if (o instanceof ElasticSearchMailboxConfiguration) {
            ElasticSearchMailboxConfiguration that = (ElasticSearchMailboxConfiguration)o;
            return Objects.equals((Object)this.indexAttachment, (Object)that.indexAttachment) && Objects.equals(this.indexMailboxName, that.indexMailboxName) && Objects.equals(this.readAliasMailboxName, that.readAliasMailboxName) && Objects.equals(this.writeAliasMailboxName, that.writeAliasMailboxName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.indexMailboxName, this.readAliasMailboxName, this.writeAliasMailboxName, this.indexAttachment, this.writeAliasMailboxName});
    }

    public static class Builder {
        private Optional<IndexName> indexMailboxName = Optional.empty();
        private Optional<ReadAliasName> readAliasMailboxName = Optional.empty();
        private Optional<WriteAliasName> writeAliasMailboxName = Optional.empty();
        private Optional<IndexAttachments> indexAttachment = Optional.empty();

        Builder() {
        }

        Builder indexMailboxName(Optional<IndexName> indexMailboxName) {
            this.indexMailboxName = indexMailboxName;
            return this;
        }

        Builder readAliasMailboxName(Optional<ReadAliasName> readAliasMailboxName) {
            this.readAliasMailboxName = readAliasMailboxName;
            return this;
        }

        Builder writeAliasMailboxName(Optional<WriteAliasName> writeAliasMailboxName) {
            this.writeAliasMailboxName = writeAliasMailboxName;
            return this;
        }

        Builder indexAttachment(IndexAttachments indexAttachment) {
            this.indexAttachment = Optional.of(indexAttachment);
            return this;
        }

        public ElasticSearchMailboxConfiguration build() {
            return new ElasticSearchMailboxConfiguration(this.indexMailboxName.orElse(MailboxElasticSearchConstants.DEFAULT_MAILBOX_INDEX), this.readAliasMailboxName.orElse(MailboxElasticSearchConstants.DEFAULT_MAILBOX_READ_ALIAS), this.writeAliasMailboxName.orElse(MailboxElasticSearchConstants.DEFAULT_MAILBOX_WRITE_ALIAS), this.indexAttachment.orElse(IndexAttachments.YES));
        }
    }
}

