/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.api.SimpleTokenManager;
import org.apache.james.jmap.draft.model.AttachmentAccessToken;
import org.apache.james.jmap.http.AuthenticationChallenge;
import org.apache.james.jmap.http.AuthenticationScheme;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;

public class QueryParameterAccessTokenAuthenticationStrategy
implements AuthenticationStrategy {
    private static final String AUTHENTICATION_PARAMETER = "access_token";
    private final SimpleTokenManager tokenManager;
    private final MailboxManager mailboxManager;

    @Inject
    @VisibleForTesting
    QueryParameterAccessTokenAuthenticationStrategy(SimpleTokenManager tokenManager, MailboxManager mailboxManager) {
        this.tokenManager = tokenManager;
        this.mailboxManager = mailboxManager;
    }

    public Mono<MailboxSession> createMailboxSession(HttpServerRequest httpRequest) {
        return Mono.justOrEmpty(this.getAccessToken(httpRequest)).filter(this.tokenManager::isValid).map(AttachmentAccessToken::getUsername).map(Username::of).map(arg_0 -> ((MailboxManager)this.mailboxManager).createSystemSession(arg_0));
    }

    public AuthenticationChallenge correspondingChallenge() {
        return AuthenticationChallenge.of((AuthenticationScheme)AuthenticationScheme.of((String)"QueryParameterBearer"), (Map)ImmutableMap.of((Object)"realm", (Object)"JMAP Draft access token over Query parameter"));
    }

    private Optional<AttachmentAccessToken> getAccessToken(HttpServerRequest httpRequest) {
        try {
            return Optional.ofNullable(httpRequest.param((CharSequence)"blobId")).flatMap(blobId -> this.queryParam(httpRequest, AUTHENTICATION_PARAMETER).map(serializedAttachmentAccessToken -> AttachmentAccessToken.from(serializedAttachmentAccessToken, blobId)));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private Optional<String> queryParam(HttpServerRequest httpRequest, String parameterName) {
        return this.queryParam(parameterName, httpRequest.uri());
    }

    private Optional<String> queryParam(String parameterName, String uri) {
        return Optional.ofNullable((List)new QueryStringDecoder(uri).parameters().get(parameterName)).stream().flatMap(Collection::stream).findFirst();
    }
}

