/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.mail.Flags;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.AttachmentLoader;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraIndexTableHandler;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.MailboxDeleteDuringUpdateException;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class CassandraMessageIdMapper
implements MessageIdMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraMessageIdMapper.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int MAX_RETRY = 5;
    private static final Duration MIN_RETRY_BACKOFF = Duration.ofMillis(10L);
    private static final Duration MAX_RETRY_BACKOFF = Duration.ofMillis(1000L);
    private final MailboxMapper mailboxMapper;
    private final CassandraMailboxDAO mailboxDAO;
    private final CassandraMessageIdToImapUidDAO imapUidDAO;
    private final CassandraMessageIdDAO messageIdDAO;
    private final CassandraMessageDAO messageDAO;
    private final CassandraMessageDAOV3 messageDAOV3;
    private final CassandraIndexTableHandler indexTableHandler;
    private final ModSeqProvider modSeqProvider;
    private final AttachmentLoader attachmentLoader;
    private final BlobStore blobStore;
    private final CassandraConfiguration cassandraConfiguration;

    public CassandraMessageIdMapper(MailboxMapper mailboxMapper, CassandraMailboxDAO mailboxDAO, CassandraAttachmentMapper attachmentMapper, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMessageIdDAO messageIdDAO, CassandraMessageDAO messageDAO, CassandraMessageDAOV3 messageDAOV3, CassandraIndexTableHandler indexTableHandler, ModSeqProvider modSeqProvider, BlobStore blobStore, CassandraConfiguration cassandraConfiguration) {
        this.mailboxMapper = mailboxMapper;
        this.mailboxDAO = mailboxDAO;
        this.imapUidDAO = imapUidDAO;
        this.messageIdDAO = messageIdDAO;
        this.messageDAO = messageDAO;
        this.messageDAOV3 = messageDAOV3;
        this.indexTableHandler = indexTableHandler;
        this.modSeqProvider = modSeqProvider;
        this.attachmentLoader = new AttachmentLoader(attachmentMapper);
        this.blobStore = blobStore;
        this.cassandraConfiguration = cassandraConfiguration;
    }

    public List<MailboxMessage> find(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        return (List)this.findReactive(messageIds, fetchType).collectList().block();
    }

    public Flux<MailboxMessage> findReactive(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        return Flux.fromIterable(messageIds).flatMap(messageId -> this.imapUidDAO.retrieve((CassandraMessageId)messageId, Optional.empty(), this.chooseReadConsistency()), this.cassandraConfiguration.getMessageReadChunkSize()).flatMap(metadata -> this.toMailboxMessage((CassandraMessageMetadata)metadata, fetchType), this.cassandraConfiguration.getMessageReadChunkSize()).groupBy(MailboxMessage::getMailboxId).flatMap(this::keepMessageIfMailboxExists, 16);
    }

    private Mono<MailboxMessage> toMailboxMessage(CassandraMessageMetadata metadata, MessageMapper.FetchType fetchType) {
        if (fetchType == MessageMapper.FetchType.METADATA && metadata.isComplete()) {
            return Mono.just((Object)metadata.asMailboxMessage(EMPTY_BYTE_ARRAY));
        }
        if (fetchType == MessageMapper.FetchType.HEADERS && metadata.isComplete()) {
            return Mono.from((Publisher)this.blobStore.readBytes(this.blobStore.getDefaultBucketName(), metadata.getHeaderContent().get(), BlobStore.StoragePolicy.SIZE_BASED)).map(metadata::asMailboxMessage);
        }
        return this.messageDAOV3.retrieveMessage(metadata.getComposedMessageId(), fetchType).switchIfEmpty(Mono.defer(() -> this.messageDAO.retrieveMessage(metadata.getComposedMessageId(), fetchType))).map(messageRepresentation -> Pair.of((Object)metadata.getComposedMessageId(), (Object)messageRepresentation)).flatMap(messageRepresentation -> this.attachmentLoader.addAttachmentToMessage((Pair<ComposedMessageIdWithMetaData, MessageRepresentation>)messageRepresentation, fetchType));
    }

    public Publisher<ComposedMessageIdWithMetaData> findMetadata(MessageId messageId) {
        return this.imapUidDAO.retrieve((CassandraMessageId)messageId, Optional.empty(), this.chooseReadConsistency()).map(CassandraMessageMetadata::getComposedMessageId);
    }

    private Flux<MailboxMessage> keepMessageIfMailboxExists(GroupedFlux<MailboxId, MailboxMessage> groupedFlux) {
        CassandraId cassandraId = (CassandraId)groupedFlux.key();
        return this.mailboxDAO.retrieveMailbox(cassandraId).flatMapMany(any -> groupedFlux).switchIfEmpty((Publisher)groupedFlux.map(message -> {
            LOGGER.info("Mailbox {} have been deleted but message {} is still attached to it.", (Object)cassandraId.serialize(), (Object)message.getMessageId().serialize());
            return message;
        }).then(Mono.empty()));
    }

    public List<MailboxId> findMailboxes(MessageId messageId) {
        return (List)this.imapUidDAO.retrieve((CassandraMessageId)messageId, Optional.empty(), this.chooseReadConsistency()).map(CassandraMessageMetadata::getComposedMessageId).map(ComposedMessageIdWithMetaData::getComposedMessageId).map(ComposedMessageId::getMailboxId).collectList().block();
    }

    public CassandraConsistenciesConfiguration.ConsistencyChoice chooseReadConsistency() {
        if (this.cassandraConfiguration.isMessageReadStrongConsistency()) {
            return CassandraConsistenciesConfiguration.ConsistencyChoice.STRONG;
        }
        return CassandraConsistenciesConfiguration.ConsistencyChoice.WEAK;
    }

    private CassandraConsistenciesConfiguration.ConsistencyChoice chooseReadConsistencyUponWrites() {
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return CassandraConsistenciesConfiguration.ConsistencyChoice.STRONG;
        }
        return CassandraConsistenciesConfiguration.ConsistencyChoice.WEAK;
    }

    public void save(MailboxMessage mailboxMessage) throws MailboxException {
        CassandraId mailboxId = (CassandraId)mailboxMessage.getMailboxId();
        MailboxReactorUtils.block((Mono)this.mailboxMapper.findMailboxById((MailboxId)mailboxId).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException((MailboxId)mailboxId))).then(this.messageDAOV3.save(mailboxMessage)).flatMap(headerAndBody -> this.saveMessageMetadata(mailboxMessage, mailboxId, (BlobId)headerAndBody.getT1())));
    }

    public void copyInMailbox(MailboxMessage mailboxMessage, Mailbox mailbox) throws MailboxException {
        MailboxReactorUtils.block(this.copyInMailboxReactive(mailboxMessage, mailbox));
    }

    public Mono<Void> copyInMailboxReactive(MailboxMessage mailboxMessage, Mailbox mailbox) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.insertMetadata(mailboxMessage, mailboxId, CassandraMessageMetadata.from(mailboxMessage).withMailboxId(mailboxId));
    }

    private Mono<Void> saveMessageMetadata(MailboxMessage mailboxMessage, CassandraId mailboxId, BlobId headerBlobId) {
        CassandraMessageMetadata metadata = CassandraMessageMetadata.from(mailboxMessage, headerBlobId).withMailboxId(mailboxId);
        return this.insertMetadata(mailboxMessage, mailboxId, metadata);
    }

    private Mono<Void> insertMetadata(MailboxMessage mailboxMessage, CassandraId mailboxId, CassandraMessageMetadata metadata) {
        return this.imapUidDAO.insert(metadata).thenEmpty((Publisher)Flux.merge((Publisher[])new Publisher[]{this.messageIdDAO.insert(metadata).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_RETRY_BACKOFF).maxBackoff(MAX_RETRY_BACKOFF)), this.indexTableHandler.updateIndexOnAdd(mailboxMessage, mailboxId)}).then());
    }

    public void delete(MessageId messageId, Collection<MailboxId> mailboxIds) {
        this.deleteReactive(messageId, mailboxIds).block();
    }

    public Mono<Void> deleteReactive(MessageId messageId, Collection<MailboxId> mailboxIds) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        return Flux.fromStream(mailboxIds.stream()).flatMap(mailboxId -> this.retrieveAndDeleteIndices(cassandraMessageId, Optional.of((CassandraId)mailboxId)), 16).then();
    }

    public void delete(Multimap<MessageId, MailboxId> ids) {
        this.deleteReactive(ids).block();
    }

    public Mono<Void> deleteReactive(Multimap<MessageId, MailboxId> ids) {
        return Flux.fromIterable(ids.asMap().entrySet()).publishOn(Schedulers.elastic()).flatMap(entry -> this.deleteReactive((MessageId)entry.getKey(), (Collection)entry.getValue()), this.cassandraConfiguration.getExpungeChunkSize(), 16).then();
    }

    private Mono<Void> retrieveAndDeleteIndices(CassandraMessageId messageId, Optional<CassandraId> mailboxId) {
        return this.imapUidDAO.retrieve(messageId, mailboxId, this.chooseReadConsistencyUponWrites()).map(CassandraMessageMetadata::getComposedMessageId).flatMap(this::deleteIds, 16).then();
    }

    public void delete(MessageId messageId) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        this.retrieveAndDeleteIndices(cassandraMessageId, Optional.empty()).block();
    }

    private Mono<Void> deleteIds(ComposedMessageIdWithMetaData metaData) {
        CassandraMessageId messageId = (CassandraMessageId)metaData.getComposedMessageId().getMessageId();
        CassandraId mailboxId = (CassandraId)metaData.getComposedMessageId().getMailboxId();
        return Flux.merge((Publisher[])new Publisher[]{this.imapUidDAO.delete(messageId, mailboxId), this.messageIdDAO.delete(mailboxId, metaData.getComposedMessageId().getUid())}).then(this.indexTableHandler.updateIndexOnDelete(metaData, mailboxId));
    }

    public Mono<Multimap<MailboxId, UpdatedFlags>> setFlags(MessageId messageId, List<MailboxId> mailboxIds, Flags newState, MessageManager.FlagsUpdateMode updateMode) {
        return Flux.fromIterable(mailboxIds).distinct().map(CassandraId.class::cast).concatMap(mailboxId -> this.flagsUpdateWithRetry(newState, updateMode, (MailboxId)mailboxId, messageId)).flatMap(this::updateCounts, 16).collect(ImmutableListMultimap.toImmutableListMultimap(Pair::getLeft, Pair::getRight));
    }

    private Flux<Pair<MailboxId, UpdatedFlags>> flagsUpdateWithRetry(Flags newState, MessageManager.FlagsUpdateMode updateMode, MailboxId mailboxId, MessageId messageId) {
        return this.updateFlags(mailboxId, messageId, newState, updateMode).retry((long)this.cassandraConfiguration.getFlagsUpdateMessageIdMaxRetry()).onErrorResume(MailboxDeleteDuringUpdateException.class, e -> {
            LOGGER.info("Mailbox {} was deleted during flag update", (Object)mailboxId);
            return Mono.empty();
        }).flux().flatMapIterable(Function.identity()).map(pair -> this.buildUpdatedFlags((ComposedMessageIdWithMetaData)pair.getRight(), (Flags)pair.getLeft()));
    }

    private Pair<MailboxId, UpdatedFlags> buildUpdatedFlags(ComposedMessageIdWithMetaData composedMessageIdWithMetaData, Flags oldFlags) {
        return Pair.of((Object)composedMessageIdWithMetaData.getComposedMessageId().getMailboxId(), (Object)UpdatedFlags.builder().uid(composedMessageIdWithMetaData.getComposedMessageId().getUid()).messageId(composedMessageIdWithMetaData.getComposedMessageId().getMessageId()).modSeq(composedMessageIdWithMetaData.getModSeq()).oldFlags(oldFlags).newFlags(composedMessageIdWithMetaData.getFlags()).build());
    }

    private Mono<Pair<MailboxId, UpdatedFlags>> updateCounts(Pair<MailboxId, UpdatedFlags> pair) {
        CassandraId cassandraId = (CassandraId)pair.getLeft();
        return this.indexTableHandler.updateIndexOnFlagsUpdate(cassandraId, (UpdatedFlags)pair.getRight()).thenReturn(pair);
    }

    private Mono<List<Pair<Flags, ComposedMessageIdWithMetaData>>> updateFlags(MailboxId mailboxId, MessageId messageId, Flags newState, MessageManager.FlagsUpdateMode updateMode) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.imapUidDAO.retrieve((CassandraMessageId)messageId, Optional.of(cassandraId), this.chooseReadConsistencyUponWrites()).map(CassandraMessageMetadata::getComposedMessageId).flatMap(oldComposedId -> this.updateFlags(newState, updateMode, cassandraId, (ComposedMessageIdWithMetaData)oldComposedId), 16).switchIfEmpty((Publisher)Mono.error(MailboxDeleteDuringUpdateException::new)).collectList();
    }

    private Mono<Pair<Flags, ComposedMessageIdWithMetaData>> updateFlags(Flags newState, MessageManager.FlagsUpdateMode updateMode, CassandraId cassandraId, ComposedMessageIdWithMetaData oldComposedId) {
        Flags newFlags = new FlagsUpdateCalculator(newState, updateMode).buildNewFlags(oldComposedId.getFlags());
        if (this.identicalFlags(oldComposedId, newFlags)) {
            return Mono.just((Object)Pair.of((Object)oldComposedId.getFlags(), (Object)oldComposedId));
        }
        return this.modSeqProvider.nextModSeqReactive((MailboxId)cassandraId).map(modSeq -> new ComposedMessageIdWithMetaData(oldComposedId.getComposedMessageId(), newFlags, modSeq, oldComposedId.getThreadId())).flatMap(newComposedId -> this.updateFlags(oldComposedId, (ComposedMessageIdWithMetaData)newComposedId));
    }

    private boolean identicalFlags(ComposedMessageIdWithMetaData oldComposedId, Flags newFlags) {
        return oldComposedId.getFlags().equals((Object)newFlags);
    }

    private Mono<Pair<Flags, ComposedMessageIdWithMetaData>> updateFlags(ComposedMessageIdWithMetaData oldComposedId, ComposedMessageIdWithMetaData newComposedId) {
        ComposedMessageId composedMessageId = newComposedId.getComposedMessageId();
        ModSeq previousModseq = oldComposedId.getModSeq();
        UpdatedFlags updatedFlags = UpdatedFlags.builder().messageId(composedMessageId.getMessageId()).modSeq(newComposedId.getModSeq()).oldFlags(oldComposedId.getFlags()).newFlags(newComposedId.getFlags()).uid(composedMessageId.getUid()).build();
        return this.imapUidDAO.updateMetadata(composedMessageId, updatedFlags, previousModseq).filter(FunctionalUtils.identityPredicate()).flatMap(any -> this.messageIdDAO.updateMetadata(composedMessageId, updatedFlags).thenReturn((Object)Pair.of((Object)oldComposedId.getFlags(), (Object)newComposedId))).single();
    }
}

