/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersService;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersTask;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;

public class RecomputeMailboxCountersTaskDTO
implements TaskDTO {
    private final String type;
    private final Optional<Boolean> trustMessageProjection;

    private static RecomputeMailboxCountersTaskDTO toDTO(RecomputeMailboxCountersTask domainObject, String typeName) {
        return new RecomputeMailboxCountersTaskDTO(typeName, Optional.of(domainObject.getOptions().isMessageProjectionTrusted()));
    }

    public static TaskDTOModule<RecomputeMailboxCountersTask, RecomputeMailboxCountersTaskDTO> module(RecomputeMailboxCountersService service) {
        return (TaskDTOModule)DTOModule.forDomainObject(RecomputeMailboxCountersTask.class).convertToDTO(RecomputeMailboxCountersTaskDTO.class).toDomainObjectConverter(dto -> dto.toDomainObject(service)).toDTOConverter(RecomputeMailboxCountersTaskDTO::toDTO).typeName(RecomputeMailboxCountersTask.RECOMPUTE_MAILBOX_COUNTERS.asString()).withFactory(TaskDTOModule::new);
    }

    public RecomputeMailboxCountersTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="trustMessageProjection") Optional<Boolean> trustMessageProjection) {
        this.type = type;
        this.trustMessageProjection = trustMessageProjection;
    }

    private RecomputeMailboxCountersTask toDomainObject(RecomputeMailboxCountersService service) {
        RecomputeMailboxCountersService.Options options = this.trustMessageProjection.map(RecomputeMailboxCountersService.Options::of).orElse(RecomputeMailboxCountersService.Options.recheckMessageProjection());
        return new RecomputeMailboxCountersTask(service, options);
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="trustMessageProjection")
    public Optional<Boolean> trustMessageProjection() {
        return this.trustMessageProjection;
    }
}

