/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.Date;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.queue.rabbitmq.MailQueueName;
import reactor.core.publisher.Mono;

public class BrowseStartDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement selectOne;
    private final PreparedStatement insertOne;
    private final PreparedStatement updateOne;

    @Inject
    BrowseStartDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.selectOne = this.prepareSelectOne(session);
        this.updateOne = this.prepareUpdate(session);
        this.insertOne = this.prepareInsertOne(session);
    }

    private PreparedStatement prepareSelectOne(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("browseStart").where(QueryBuilder.eq((String)"queueName", (Object)QueryBuilder.bindMarker((String)"queueName"))));
    }

    private PreparedStatement prepareUpdate(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"browseStart").with(QueryBuilder.set((String)"browseStart", (Object)QueryBuilder.bindMarker((String)"browseStart"))).where(QueryBuilder.eq((String)"queueName", (Object)QueryBuilder.bindMarker((String)"queueName"))));
    }

    private PreparedStatement prepareInsertOne(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"browseStart").ifNotExists().value("browseStart", (Object)QueryBuilder.bindMarker((String)"browseStart")).value("queueName", (Object)QueryBuilder.bindMarker((String)"queueName")));
    }

    Mono<Instant> findBrowseStart(MailQueueName queueName) {
        return this.selectOne(queueName).map(this::getBrowseStart);
    }

    Mono<Void> updateBrowseStart(MailQueueName mailQueueName, Instant sliceStart) {
        return this.executor.executeVoid((Statement)this.updateOne.bind().setTimestamp("browseStart", Date.from(sliceStart)).setString("queueName", mailQueueName.asString()));
    }

    Mono<Void> insertInitialBrowseStart(MailQueueName mailQueueName, Instant sliceStart) {
        return this.executor.executeVoid((Statement)this.insertOne.bind().setTimestamp("browseStart", Date.from(sliceStart)).setString("queueName", mailQueueName.asString()));
    }

    @VisibleForTesting
    Mono<Row> selectOne(MailQueueName queueName) {
        return this.executor.executeSingleRow((Statement)this.selectOne.bind().setString("queueName", queueName.asString()));
    }

    private Instant getBrowseStart(Row row) {
        return row.getTimestamp("browseStart").toInstant();
    }
}

