/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.ThreadNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.MimeMessageId;
import org.apache.james.mailbox.store.mail.model.Subject;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SearchThreadIdGuessingAlgorithm
implements ThreadIdGuessingAlgorithm {
    private final MailboxManager mailboxManager;
    private final MessageIdManager messageIdManager;

    @Inject
    public SearchThreadIdGuessingAlgorithm(MailboxManager mailboxManager, MessageIdManager messageIdManager) {
        this.mailboxManager = mailboxManager;
        this.messageIdManager = messageIdManager;
    }

    @Override
    public Mono<ThreadId> guessThreadIdReactive(MessageId messageId, Optional<MimeMessageId> mimeMessageId, Optional<MimeMessageId> inReplyTo, Optional<List<MimeMessageId>> references, Optional<Subject> subject, MailboxSession session) {
        MultimailboxesSearchQuery expression = this.buildSearchQuery(mimeMessageId, inReplyTo, references, subject);
        return Flux.from((Publisher)this.mailboxManager.search(expression, session, 1L)).collectList().flatMapMany(messageIds -> this.messageIdManager.getMessagesReactive((Collection)messageIds, FetchGroup.MINIMAL, session)).map(MessageResult::getThreadId).next().switchIfEmpty(Mono.just((Object)ThreadId.fromBaseMessageId((MessageId)messageId)));
    }

    @Override
    public Flux<MessageId> getMessageIdsInThread(ThreadId threadId, MailboxSession session) {
        SearchQuery searchQuery = SearchQuery.builder().andCriteria(new SearchQuery.Criterion[]{SearchQuery.threadId((ThreadId)threadId)}).sorts(new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.Arrival, SearchQuery.Sort.Order.NATURAL)}).build();
        MultimailboxesSearchQuery expression = MultimailboxesSearchQuery.from((SearchQuery)searchQuery).build();
        return Flux.from((Publisher)this.mailboxManager.search(expression, session, Integer.MAX_VALUE)).switchIfEmpty((Publisher)Mono.error(() -> new ThreadNotFoundException(threadId)));
    }

    private MultimailboxesSearchQuery buildSearchQuery(Optional<MimeMessageId> mimeMessageId, Optional<MimeMessageId> inReplyTo, Optional<List<MimeMessageId>> references, Optional<Subject> subject) {
        Set<MimeMessageId> mimeMessageIds = this.buildMimeMessageIdSet(mimeMessageId, inReplyTo, references);
        ImmutableList.Builder mimeMessageIdCriteriaBuilder = ImmutableList.builder();
        mimeMessageIds.forEach(value -> {
            mimeMessageIdCriteriaBuilder.add((Object)SearchQuery.mimeMessageID((String)value.getValue()));
            mimeMessageIdCriteriaBuilder.add((Object)SearchQuery.headerContains((String)"In-Reply-To", (String)value.getValue()));
            mimeMessageIdCriteriaBuilder.add((Object)SearchQuery.headerContains((String)"References", (String)value.getValue()));
        });
        SearchQuery.Criterion mimeMessageIdCriterion = SearchQuery.or((List)mimeMessageIdCriteriaBuilder.build());
        SearchQuery.Criterion finalCriterion = subject.map(value -> SearchQuery.and((SearchQuery.Criterion)mimeMessageIdCriterion, (SearchQuery.Criterion)SearchQuery.headerContains((String)"Subject", (String)SearchUtil.getBaseSubject(value.getValue())))).orElse(mimeMessageIdCriterion);
        return MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{finalCriterion})).build();
    }

    private Set<MimeMessageId> buildMimeMessageIdSet(Optional<MimeMessageId> mimeMessageId, Optional<MimeMessageId> inReplyTo, Optional<List<MimeMessageId>> references) {
        HashSet<MimeMessageId> mimeMessageIds = new HashSet<MimeMessageId>();
        mimeMessageId.ifPresent(mimeMessageIds::add);
        inReplyTo.ifPresent(mimeMessageIds::add);
        references.ifPresent(mimeMessageIds::addAll);
        return mimeMessageIds;
    }
}

