/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxConnection
implements Closeable {
    private static final String fmtUrl = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private static final int defaultPort = 9999;
    private final JMXConnector jmxConnector;

    public static JmxConnection defaultJmxConnection(String host) throws IOException {
        return new JmxConnection(host, 9999, Optional.empty());
    }

    public JmxConnection(String host, int port, Optional<AuthCredential> authCredential) throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format(fmtUrl, host, port));
        Map env = (Map)authCredential.map(credential -> ImmutableMap.of((Object)"jmx.remote.credentials", (Object)new String[]{credential.username, credential.password})).orElse(ImmutableMap.of());
        this.jmxConnector = JMXConnectorFactory.connect(jmxUrl, env);
    }

    @Override
    public void close() throws IOException {
        this.jmxConnector.close();
    }

    public <T> T retrieveBean(Class<T> mbeanType, String name) throws MalformedObjectNameException, IOException {
        return MBeanServerInvocationHandler.newProxyInstance(this.getMBeanServerConnection(), new ObjectName(name), mbeanType, true);
    }

    private MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.jmxConnector.getMBeanServerConnection();
    }

    public static class AuthCredential {
        String username;
        String password;

        public AuthCredential(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public final boolean equals(Object o) {
            if (o instanceof AuthCredential) {
                AuthCredential that = (AuthCredential)o;
                return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.username, this.password);
        }
    }
}

