/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra.cache;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.util.DurationParser;
import org.apache.james.util.SizeFormat;

public class CassandraCacheConfiguration {
    public static final CassandraCacheConfiguration DEFAULT = CassandraCacheConfiguration.builder().build();
    private final Duration readTimeOut;
    private final int sizeThresholdInBytes;
    private final Duration ttl;

    public static Builder builder() {
        return new Builder();
    }

    public static CassandraCacheConfiguration from(Configuration configuration) {
        Optional<Duration> ttl = Optional.ofNullable(configuration.getString("cache.cassandra.ttl", null)).map(value -> DurationParser.parse((String)value, (ChronoUnit)ChronoUnit.SECONDS));
        Optional<Duration> timeOut = Optional.ofNullable(configuration.getString("cache.cassandra.timeout", null)).map(value -> DurationParser.parse((String)value, (ChronoUnit)ChronoUnit.SECONDS));
        Optional<Integer> sizeThreshold = Optional.ofNullable(configuration.getString("cache.sizeThresholdInBytes", null)).map(SizeFormat::parseAsByteCount).map(Math::toIntExact);
        return CassandraCacheConfiguration.builder().ttl(ttl).timeOut(timeOut).sizeThresholdInBytes(sizeThreshold).build();
    }

    private CassandraCacheConfiguration(Duration timeout, int sizeThresholdInBytes, Duration ttl) {
        this.readTimeOut = timeout;
        this.sizeThresholdInBytes = sizeThresholdInBytes;
        this.ttl = ttl;
    }

    public Duration getReadTimeOut() {
        return this.readTimeOut;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public int getSizeThresholdInBytes() {
        return this.sizeThresholdInBytes;
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraCacheConfiguration) {
            CassandraCacheConfiguration that = (CassandraCacheConfiguration)o;
            return Objects.equals(this.sizeThresholdInBytes, that.sizeThresholdInBytes) && Objects.equals(this.readTimeOut, that.readTimeOut) && Objects.equals(this.ttl, that.ttl);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.readTimeOut, this.sizeThresholdInBytes, this.ttl);
    }

    public static class Builder {
        private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMillis(100L);
        private static final Duration MAX_READ_TIMEOUT = Duration.ofHours(1L);
        private static final Duration DEFAULT_TTL = Duration.ofDays(7L);
        private static final int DEFAULT_BYTE_THRESHOLD_SIZE = 8192;
        private Optional<Duration> readTimeout = Optional.empty();
        private Optional<Integer> sizeThresholdInBytes = Optional.empty();
        private Optional<Duration> ttl = Optional.empty();

        public Builder timeOut(Duration timeout) {
            Preconditions.checkNotNull((Object)timeout, (Object)"'Read timeout' must not to be null");
            Preconditions.checkArgument((timeout.toMillis() > 0L ? 1 : 0) != 0, (Object)"'Read timeout' needs to be positive");
            Preconditions.checkArgument((timeout.getSeconds() <= MAX_READ_TIMEOUT.getSeconds() ? 1 : 0) != 0, (String)"'Read timeout' needs to be less than %s sec", (long)MAX_READ_TIMEOUT.getSeconds());
            this.readTimeout = Optional.of(timeout);
            return this;
        }

        public Builder sizeThresholdInBytes(int sizeThresholdInBytes) {
            Preconditions.checkArgument((sizeThresholdInBytes >= 0 ? 1 : 0) != 0, (Object)"'Threshold size' needs to be positive");
            this.sizeThresholdInBytes = Optional.of(sizeThresholdInBytes);
            return this;
        }

        public Builder ttl(Duration ttl) {
            Preconditions.checkNotNull((Object)ttl, (Object)"'TTL' must not to be null");
            Preconditions.checkArgument((ttl.getSeconds() > 0L ? 1 : 0) != 0, (Object)"'TTL' needs to be positive");
            Preconditions.checkArgument((ttl.getSeconds() < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"'TTL' must not greater than %s sec", (int)Integer.MAX_VALUE);
            this.ttl = Optional.of(ttl);
            return this;
        }

        public Builder ttl(Optional<Duration> ttl) {
            ttl.ifPresent(this::ttl);
            return this;
        }

        public Builder timeOut(Optional<Duration> timeOut) {
            timeOut.ifPresent(this::timeOut);
            return this;
        }

        public Builder sizeThresholdInBytes(Optional<Integer> sizeThresholdInBytes) {
            sizeThresholdInBytes.ifPresent(this::sizeThresholdInBytes);
            return this;
        }

        public CassandraCacheConfiguration build() {
            return new CassandraCacheConfiguration(this.readTimeout.orElse(DEFAULT_READ_TIMEOUT), this.sizeThresholdInBytes.orElse(8192), this.ttl.orElse(DEFAULT_TTL));
        }
    }
}

