/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mu;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.github.fge.lambdas.Throwing;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.init.CassandraTableManager;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mu.MailReportEntry;
import org.apache.james.mu.MailReportGenerator;
import org.apache.james.util.DurationParser;
import org.apache.james.utils.UserDefinedStartable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class CassandraMailReportGenerator
implements MailReportGenerator,
UserDefinedStartable {
    public static final CqlIdentifier ID = CqlIdentifier.fromCql((String)"id");
    public static final String TABLE_NAME = "mu_mail_report";
    public static final CqlIdentifier KIND = CqlIdentifier.fromCql((String)"kind");
    public static final CqlIdentifier SENDER = CqlIdentifier.fromCql((String)"sender");
    public static final CqlIdentifier RECIPIENT = CqlIdentifier.fromCql((String)"recipient");
    public static final CqlIdentifier SUBJECT = CqlIdentifier.fromCql((String)"subject");
    public static final CqlIdentifier DATE = CqlIdentifier.fromCql((String)"date");
    public static final int TTL = (int)DurationParser.parse((String)System.getProperty("mu.report.retention", "365d")).getSeconds();
    private static CassandraModule MODULE = CassandraModule.builder().table("mu_mail_report").comment("MU sent and received mail audit trail").options(options -> (CreateTableWithOptions)options.withGcGraceSeconds(0)).statement(statement -> types -> statement.withPartitionKey(ID, DataTypes.TIMEUUID).withColumn(KIND, DataTypes.TEXT).withColumn(SENDER, DataTypes.TEXT).withColumn(RECIPIENT, DataTypes.TEXT).withColumn(SUBJECT, DataTypes.TEXT).withColumn(DATE, DataTypes.TIMESTAMP)).build();
    private final CqlSession session;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final CassandraTypesProvider typesProvider;
    private PreparedStatement insert;
    private PreparedStatement select;

    @Inject
    public CassandraMailReportGenerator(CqlSession session, CassandraTypesProvider typesProvider) {
        this.session = session;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.typesProvider = typesProvider;
    }

    public void start() {
        new CassandraTableManager(MODULE, this.session).initializeTables(this.typesProvider);
        this.insert = this.prepareInsert();
        this.select = this.prepareSelect();
    }

    private PreparedStatement prepareInsert() {
        return this.session.prepare(QueryBuilder.insertInto((String)TABLE_NAME).value(ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)ID)).value(KIND, (Term)QueryBuilder.bindMarker((CqlIdentifier)KIND)).value(SENDER, (Term)QueryBuilder.bindMarker((CqlIdentifier)SENDER)).value(RECIPIENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)RECIPIENT)).value(SUBJECT, (Term)QueryBuilder.bindMarker((CqlIdentifier)SUBJECT)).value(DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)DATE)).usingTtl(TTL).build());
    }

    private PreparedStatement prepareSelect() {
        return this.session.prepare(QueryBuilder.selectFrom((String)TABLE_NAME).all().build());
    }

    @Override
    public Mono<Void> append(MailReportEntry entry) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).setUuid(ID, Uuids.timeBased())).setString(KIND, entry.kind().asString())).setString(SENDER, entry.sender().asString())).setString(RECIPIENT, entry.recipient().asString())).setString(SUBJECT, entry.subject())).setInstant(DATE, entry.date()));
    }

    @Override
    public Flux<MailReportEntry> generateReport(Instant start, Instant end) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.select.bind(new Object[0])).handle((row, sink) -> MailReportEntry.Kind.parse(row.getString(KIND)).flatMap(Throwing.function(kind -> Optional.of(new MailReportEntry((MailReportEntry.Kind)((Object)((Object)kind)), row.getString(SUBJECT), MaybeSender.getMailSender((String)row.getString(SENDER)), new MailAddress(row.getString(RECIPIENT)), row.getInstant(DATE))))).ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0)));
    }
}

