/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.base.Preconditions;
import java.util.Objects;

public class AddressType {
    public static final AddressType DNS = new AddressType("dns");
    public static final AddressType RFC_822 = new AddressType("rfc822");
    public static final AddressType UNKNOWN = new AddressType("unknown");
    private final String type;

    public AddressType(String type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(!type.contains("\n"), "Address type can not be multiline");
        String trimmedType = type.trim();
        Preconditions.checkArgument(!trimmedType.isEmpty(), "Address type can not be empty");
        this.type = trimmedType;
    }

    public String getType() {
        return this.type;
    }

    public final boolean equals(Object o) {
        if (o instanceof AddressType) {
            AddressType that = (AddressType)o;
            return Objects.equals(this.type, that.type);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.type);
    }
}

