/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class MetricsMailet
extends GenericMailet {
    public static final String METRIC_NAME = "metricName";
    private final MetricFactory metricFactory;
    private Metric metric;

    @Inject
    public MetricsMailet(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public void init() throws MessagingException {
        String metricName = this.getInitParameter(METRIC_NAME);
        this.init(metricName);
    }

    private void init(String metricName) {
        Preconditions.checkNotNull((Object)metricName);
        this.metric = this.metricFactory.generate(metricName);
    }

    public void service(Mail mail) throws MessagingException {
        this.metric.increment();
    }

    public String getMailetInfo() {
        return "Metrics mailet";
    }
}

