/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.core.quota.QuotaLimitValue;

public class SerializableQuotaLimitValue<T extends QuotaLimitValue<T>>
implements Serializable {
    public static final long UNLIMITED = -1L;
    private final Long value;

    public static <U extends QuotaLimitValue<U>> SerializableQuotaLimitValue<U> valueOf(Optional<U> input) {
        return new SerializableQuotaLimitValue<QuotaLimitValue>(input.orElse(null));
    }

    private static <U extends QuotaLimitValue<U>> Long encodeAsLong(U quota) {
        if (quota.isLimited()) {
            return quota.asLong();
        }
        return -1L;
    }

    public SerializableQuotaLimitValue(T value) {
        this(SerializableQuotaLimitValue.encodeAsLong(value));
    }

    SerializableQuotaLimitValue(Long value) {
        this.value = value;
    }

    public Long encodeAsLong() {
        return this.value;
    }

    public Optional<T> toValue(Function<Long, T> factory, T unlimited) {
        Long longValue = this.encodeAsLong();
        if (longValue == null) {
            return Optional.empty();
        }
        if (longValue == -1L) {
            return Optional.of(unlimited);
        }
        return Optional.of((QuotaLimitValue)factory.apply(longValue));
    }

    public boolean equals(Object o) {
        if (o instanceof SerializableQuotaLimitValue) {
            SerializableQuotaLimitValue that = (SerializableQuotaLimitValue)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("value", this.value).toString();
    }
}

