/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.SeparatorUtil;

public class MappingsImpl
implements Mappings,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<Mapping> mappings;

    public static MappingsImpl empty() {
        return MappingsImpl.builder().build();
    }

    public static MappingsImpl fromRawString(String raw) {
        return MappingsImpl.fromCollection(MappingsImpl.mappingToCollection(raw));
    }

    public static MappingsImpl fromMappings(Mapping ... mappings) {
        return MappingsImpl.fromMappings(Arrays.stream(mappings));
    }

    private static ArrayList<String> mappingToCollection(String rawMapping) {
        ArrayList<String> map = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(rawMapping, SeparatorUtil.getSeparator(rawMapping));
        while (tokenizer.hasMoreTokens()) {
            String raw = tokenizer.nextToken().trim();
            map.add(raw);
        }
        return map;
    }

    public static MappingsImpl fromCollection(Collection<String> mappings) {
        return MappingsImpl.fromMappings(mappings.stream().map(Mapping::of));
    }

    public static MappingsImpl fromMappings(Stream<Mapping> mappings) {
        return mappings.reduce(MappingsImpl.builder(), Builder::add, Builder::merge).build();
    }

    public static Builder from(Mappings from) {
        Builder builder = new Builder();
        builder.addAll(from);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    private MappingsImpl(Collection<Mapping> mappings) {
        this.mappings = ImmutableList.copyOf(mappings);
    }

    @Override
    public Iterable<String> asStrings() {
        return this.mappings.stream().map(Mapping::asString).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean contains(Mapping mapping) {
        return this.mappings.contains(mapping);
    }

    @Override
    public int size() {
        return this.mappings.size();
    }

    @Override
    public Mappings remove(Mapping mapping) {
        if (this.mappings.contains(mapping)) {
            ArrayList<Mapping> updatedMappings = Lists.newArrayList(this.mappings);
            updatedMappings.remove(mapping);
            return new MappingsImpl(updatedMappings);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    @Override
    public Iterator<Mapping> iterator() {
        return this.mappings.iterator();
    }

    @Override
    public String serialize() {
        return Joiner.on(';').join(this.asStrings());
    }

    private Predicate<Mapping> hasType(Mapping.Type type) {
        return mapping -> mapping.getType().equals((Object)type);
    }

    @Override
    public boolean contains(Mapping.Type type) {
        Preconditions.checkNotNull(type);
        return this.mappings.stream().anyMatch(this.hasType(type));
    }

    @Override
    public Mappings select(Mapping.Type type) {
        Preconditions.checkNotNull(type);
        return MappingsImpl.fromMappings(this.mappings.stream().filter(this.hasType(type)));
    }

    @Override
    public Mappings exclude(Mapping.Type type) {
        Preconditions.checkNotNull(type);
        return MappingsImpl.fromMappings(this.mappings.stream().filter(this.hasType(type).negate()));
    }

    @Override
    public Mapping getError() {
        Mappings errors = this.select(Mapping.Type.Error);
        Preconditions.checkState(!errors.isEmpty());
        return Iterables.getFirst(errors, null);
    }

    @Override
    public Optional<Mappings> toOptional() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this);
    }

    @Override
    public Mappings union(Mappings mappings) {
        Preconditions.checkState(mappings != null, "mappings is mandatory");
        return MappingsImpl.from(this).addAll(mappings).build();
    }

    @Override
    public Stream<Mapping> asStream() {
        return this.mappings.stream();
    }

    public int hashCode() {
        return Objects.hashCode(this.mappings);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MappingsImpl) {
            MappingsImpl other = (MappingsImpl)obj;
            return Objects.equal(this.mappings, other.mappings);
        }
        return false;
    }

    public String toString() {
        return "MappingsImpl{mappings=" + this.mappings + "}";
    }

    public static class Builder {
        private final ImmutableList.Builder<Mapping> mappings = ImmutableList.builder();

        public static Builder merge(Builder builder1, Builder builder2) {
            return builder1.addAll(builder2.build());
        }

        private Builder() {
        }

        public Builder add(String mapping) {
            return this.add(Mapping.of(mapping));
        }

        public Builder add(Mapping mapping) {
            this.mappings.add((Object)mapping);
            return this;
        }

        public Builder addAll(Mappings mappings) {
            this.mappings.addAll((Iterable)mappings);
            return this;
        }

        public Builder addAll(Iterable<String> mappings) {
            mappings.forEach(this::add);
            return this;
        }

        public MappingsImpl build() {
            return new MappingsImpl(this.mappings.build().stream().sorted(new DefaultMappingOrderingPolicy().comparator()).collect(ImmutableList.toImmutableList()));
        }
    }

    private static class DefaultMappingOrderingPolicy {
        private static final Comparator<Mapping> MAPPING_COMPARATOR = Comparator.comparing(DefaultMappingOrderingPolicy::typeOrder).thenComparing(Mapping::asString);

        private DefaultMappingOrderingPolicy() {
        }

        private static int typeOrder(Mapping mapping) {
            return mapping.getType().getTypeOrder();
        }

        public Comparator<Mapping> comparator() {
            return MAPPING_COMPARATOR;
        }
    }
}

