/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.james.core.Username;

public class AccountId {
    private final String identifier;

    public static AccountId fromString(String identifier) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(identifier), "AccountId identifier should not be null or empty");
        return new AccountId(identifier);
    }

    public static AccountId fromUsername(Username username) {
        return new AccountId(username.asString());
    }

    private AccountId(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountId accountId = (AccountId)o;
        return Objects.equals(this.identifier, accountId.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

