/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.ldap.sdk.controls.SortKey;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ServerSideSortRequestControl
extends Control {
    @NotNull
    public static final String SERVER_SIDE_SORT_REQUEST_OID = "1.2.840.113556.1.4.473";
    @NotNull
    private static final String JSON_FIELD_ATTRIBUTE_NAME = "attribute-name";
    @NotNull
    private static final String JSON_FIELD_MATCHING_RULE_ID = "matching-rule-id";
    @NotNull
    private static final String JSON_FIELD_REVERSE_ORDER = "reverse-order";
    @NotNull
    private static final String JSON_FIELD_SORT_KEYS = "sort-keys";
    private static final long serialVersionUID = -3021901578330574772L;
    @NotNull
    private final SortKey[] sortKeys;

    public ServerSideSortRequestControl(SortKey ... sortKeys) {
        this(false, sortKeys);
    }

    public ServerSideSortRequestControl(@NotNull List<SortKey> sortKeys) {
        this(false, sortKeys);
    }

    public ServerSideSortRequestControl(boolean isCritical, SortKey ... sortKeys) {
        super(SERVER_SIDE_SORT_REQUEST_OID, isCritical, ServerSideSortRequestControl.encodeValue(sortKeys));
        this.sortKeys = sortKeys;
    }

    public ServerSideSortRequestControl(boolean isCritical, @NotNull List<SortKey> sortKeys) {
        this(isCritical, sortKeys.toArray(new SortKey[sortKeys.size()]));
    }

    public ServerSideSortRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.sortKeys = new SortKey[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                this.sortKeys[i] = SortKey.decode(elements[i]);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_REQUEST_CANNOT_DECODE.get(e), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull SortKey[] sortKeys) {
        Validator.ensureNotNull(sortKeys);
        Validator.ensureTrue(sortKeys.length > 0, "ServerSideSortRequestControl.sortKeys must not be empty.");
        ASN1Element[] valueElements = new ASN1Element[sortKeys.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            valueElements[i] = sortKeys[i].encode();
        }
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    @NotNull
    public SortKey[] getSortKeys() {
        return this.sortKeys;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SORT_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        ArrayList<JSONObject> sortKeyValues = new ArrayList<JSONObject>(this.sortKeys.length);
        for (SortKey sortKey : this.sortKeys) {
            LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>();
            fields.put(JSON_FIELD_ATTRIBUTE_NAME, new JSONString(sortKey.getAttributeName()));
            fields.put(JSON_FIELD_REVERSE_ORDER, new JSONBoolean(sortKey.reverseOrder()));
            if (sortKey.getMatchingRuleID() != null) {
                fields.put(JSON_FIELD_MATCHING_RULE_ID, new JSONString(sortKey.getMatchingRuleID()));
            }
            sortKeyValues.add(new JSONObject(fields));
        }
        return new JSONObject(new JSONField("oid", SERVER_SIDE_SORT_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_SORT_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_SORT_KEYS, new JSONArray(sortKeyValues)))));
    }

    @NotNull
    public static ServerSideSortRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new ServerSideSortRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        List<JSONValue> sortKeyValues = valueObject.getFieldAsArray(JSON_FIELD_SORT_KEYS);
        if (sortKeyValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_REQUEST_JSON_MISSING_SORT_KEYS.get(controlObject.toSingleLineString(), JSON_FIELD_SORT_KEYS));
        }
        if (sortKeyValues.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_REQUEST_JSON_EMPTY_SORT_KEYS.get(controlObject.toSingleLineString(), JSON_FIELD_SORT_KEYS));
        }
        ArrayList<SortKey> sortKeys = new ArrayList<SortKey>(sortKeyValues.size());
        for (JSONValue sortKeyValue : sortKeyValues) {
            if (sortKeyValue instanceof JSONObject) {
                List<String> unrecognizedFields2;
                JSONObject sortKeyObject = (JSONObject)sortKeyValue;
                String attributeName = sortKeyObject.getFieldAsString(JSON_FIELD_ATTRIBUTE_NAME);
                if (attributeName == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_REQUEST_JSON_SORT_KEY_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_SORT_KEYS, JSON_FIELD_ATTRIBUTE_NAME));
                }
                Boolean reverseOrder = sortKeyObject.getFieldAsBoolean(JSON_FIELD_REVERSE_ORDER);
                if (reverseOrder == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_REQUEST_JSON_SORT_KEY_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_SORT_KEYS, JSON_FIELD_REVERSE_ORDER));
                }
                String matchingRuleID = sortKeyObject.getFieldAsString(JSON_FIELD_MATCHING_RULE_ID);
                if (strict && !(unrecognizedFields2 = JSONControlDecodeHelper.getControlObjectUnexpectedFields(sortKeyObject, JSON_FIELD_ATTRIBUTE_NAME, JSON_FIELD_REVERSE_ORDER, JSON_FIELD_MATCHING_RULE_ID)).isEmpty()) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_REQUEST_JSON_UNRECOGNIZED_SORT_KEY_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_SORT_KEYS, unrecognizedFields2.get(0)));
                }
                sortKeys.add(new SortKey(attributeName, matchingRuleID, reverseOrder));
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_REQUEST_JSON_SORT_KEY_VALUE_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_SORT_KEYS));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_SORT_KEYS)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_REQUEST_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new ServerSideSortRequestControl(jsonControl.getCriticality(), sortKeys);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ServerSideSortRequestControl(sortKeys={");
        for (int i = 0; i < this.sortKeys.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('\'');
            this.sortKeys[i].toString(buffer);
            buffer.append('\'');
        }
        buffer.append("})");
    }
}

