/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.EndTransactionExtendedResult;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class EndTransactionExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String END_TRANSACTION_REQUEST_OID = "1.3.6.1.1.21.3";
    private static final long serialVersionUID = -7135468264026410702L;
    @NotNull
    private final ASN1OctetString transactionID;
    private final boolean commit;

    public EndTransactionExtendedRequest(@NotNull ASN1OctetString transactionID, boolean commit, Control ... controls) {
        super(END_TRANSACTION_REQUEST_OID, EndTransactionExtendedRequest.encodeValue(transactionID, commit), controls);
        this.transactionID = transactionID;
        this.commit = commit;
    }

    public EndTransactionExtendedRequest(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            if (elements.length == 1) {
                this.commit = true;
                this.transactionID = ASN1OctetString.decodeAsOctetString(elements[0]);
            } else {
                this.commit = ASN1Boolean.decodeAsBoolean(elements[0]).booleanValue();
                this.transactionID = ASN1OctetString.decodeAsOctetString(elements[1]);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_REQUEST_CANNOT_DECODE.get(e), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ASN1OctetString transactionID, boolean commit) {
        Validator.ensureNotNull(transactionID);
        ASN1Element[] valueElements = commit ? new ASN1Element[]{transactionID} : new ASN1Element[]{new ASN1Boolean(commit), transactionID};
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    @NotNull
    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    public boolean commit() {
        return this.commit;
    }

    @Override
    @NotNull
    public EndTransactionExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new EndTransactionExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public EndTransactionExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public EndTransactionExtendedRequest duplicate(@Nullable Control[] controls) {
        EndTransactionExtendedRequest r = new EndTransactionExtendedRequest(this.transactionID, this.commit, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_END_TXN.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("EndTransactionExtendedRequest(transactionID='");
        buffer.append(this.transactionID.stringValue());
        buffer.append("', commit=");
        buffer.append(this.commit);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

