/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDIFException
extends LDAPSDKException {
    private static final long serialVersionUID = 1665883395956836732L;
    private final boolean mayContinueReading;
    private final long lineNumber;
    @Nullable
    private final List<String> dataLines;

    public LDIFException(@NotNull String message, long lineNumber, boolean mayContinueReading) {
        this(message, lineNumber, mayContinueReading, (List<? extends CharSequence>)null, null);
    }

    public LDIFException(@NotNull String message, long lineNumber, boolean mayContinueReading, @Nullable Throwable cause) {
        this(message, lineNumber, mayContinueReading, (List<? extends CharSequence>)null, cause);
    }

    public LDIFException(@NotNull String message, long lineNumber, boolean mayContinueReading, @Nullable CharSequence[] dataLines, @Nullable Throwable cause) {
        this(message, lineNumber, mayContinueReading, dataLines == null ? null : Arrays.asList(dataLines), cause);
    }

    public LDIFException(@NotNull String message, long lineNumber, boolean mayContinueReading, @Nullable List<? extends CharSequence> dataLines, @Nullable Throwable cause) {
        super(message, cause);
        Validator.ensureNotNull(message);
        this.lineNumber = lineNumber;
        this.mayContinueReading = mayContinueReading;
        if (dataLines == null) {
            this.dataLines = null;
        } else {
            ArrayList<String> lineList = new ArrayList<String>(dataLines.size());
            for (CharSequence charSequence : dataLines) {
                lineList.add(charSequence.toString());
            }
            this.dataLines = Collections.unmodifiableList(lineList);
        }
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public boolean mayContinueReading() {
        return this.mayContinueReading;
    }

    @Nullable
    public List<String> getDataLines() {
        return this.dataLines;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        boolean includeCause = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages");
        boolean includeStackTrace = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages");
        this.toString(buffer, includeCause, includeStackTrace);
    }

    public void toString(@NotNull StringBuilder buffer, boolean includeCause, boolean includeStackTrace) {
        Throwable cause;
        buffer.append("LDIFException(lineNumber=");
        buffer.append(this.lineNumber);
        buffer.append(", mayContinueReading=");
        buffer.append(this.mayContinueReading);
        buffer.append(", message='");
        buffer.append(this.getMessage());
        if (this.dataLines != null) {
            buffer.append("', dataLines='");
            for (CharSequence charSequence : this.dataLines) {
                buffer.append(charSequence);
                buffer.append("{end-of-line}");
            }
        }
        if (includeStackTrace) {
            buffer.append(", trace='");
            StaticUtils.getStackTrace(this.getStackTrace(), buffer);
            buffer.append('\'');
        }
        if ((includeCause || includeStackTrace) && (cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause, true, includeStackTrace));
        }
        String ldapSDKVersionString = ", ldapSDKVersion=6.0.7, revision=76bbe43ece90ad78306ba2e5c349f33f0bf13fde";
        if (buffer.indexOf(", ldapSDKVersion=6.0.7, revision=76bbe43ece90ad78306ba2e5c349f33f0bf13fde") < 0) {
            buffer.append(", ldapSDKVersion=6.0.7, revision=76bbe43ece90ad78306ba2e5c349f33f0bf13fde");
        }
        buffer.append(')');
    }

    @Override
    @NotNull
    public String getExceptionMessage() {
        return this.toString();
    }

    @Override
    @NotNull
    public String getExceptionMessage(boolean includeCause, boolean includeStackTrace) {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, includeCause, includeStackTrace);
        return buffer.toString();
    }
}

