/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class DelegationStoreAuthorizator
implements Authorizator {
    private final DelegationStore delegationStore;
    private final UsersRepository usersRepository;

    @Inject
    public DelegationStoreAuthorizator(DelegationStore delegationStore, UsersRepository usersRepository) {
        this.delegationStore = delegationStore;
        this.usersRepository = usersRepository;
    }

    public Authorizator.AuthorizationState canLoginAsOtherUser(Username userId, Username otherUserId) throws MailboxException {
        boolean isAuthorized = (Boolean)Flux.from((Publisher)this.delegationStore.authorizedUsers(otherUserId)).hasElement((Object)userId).block();
        try {
            if (isAuthorized || this.isAdministrator(userId)) {
                return Authorizator.AuthorizationState.ALLOWED;
            }
            if (!this.usersRepository.contains(otherUserId)) {
                return Authorizator.AuthorizationState.UNKNOWN_USER;
            }
            return Authorizator.AuthorizationState.FORBIDDEN;
        }
        catch (UsersRepositoryException e) {
            throw new MailboxException("Unable to access usersRepository", (Throwable)e);
        }
    }

    @VisibleForTesting
    boolean isAdministrator(Username userId) throws UsersRepositoryException {
        if (userId.hasDomainPart() ^ this.usersRepository.supportVirtualHosting()) {
            return false;
        }
        try {
            return this.usersRepository.isAdministrator(userId);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<Username> delegatedUsers(Username username) {
        return (Collection)Flux.from((Publisher)this.delegationStore.delegatedUsers(username)).collectList().block();
    }
}

