/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.model.State;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.change.TypeState;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.PushState;
import org.apache.james.jmap.core.PushState$;
import org.apache.james.jmap.core.RequestId;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.core.UuidState;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.core.WebSocketError;
import org.apache.james.jmap.core.WebSocketInboundMessage;
import org.apache.james.jmap.core.WebSocketPushDisable$;
import org.apache.james.jmap.core.WebSocketPushEnable;
import org.apache.james.jmap.core.WebSocketRequest;
import org.apache.james.jmap.core.WebSocketResponse;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.JMAPApi;
import org.apache.james.jmap.routes.WebSocketRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%t!\u0002\u000e\u001c\u0011\u00031c!\u0002\u0015\u001c\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001b\u0007\t!Z\u0002a\u000f\u0005\t\u0011\u0016\u0011)\u0019!C\u0001\u0013\"A\u0001+\u0002B\u0001B\u0003%!\n\u0003\u0005R\u000b\t\u0005\t\u0015!\u0003S\u0011!)VA!A!\u0002\u00131\u0006\u0002\u00035\u0006\u0005\u0003\u0005\u000b\u0011B5\t\u00111,!\u0011!Q\u0001\n5D\u0001\"^\u0003\u0003\u0002\u0003\u0006IA\u001e\u0005\ts\u0016\u0011\t\u0011)A\u0005u\"Q\u0011\u0011A\u0003\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005%QA!A!\u0002\u0013\tY\u0001\u0003\u00041\u000b\u0011\u0005\u0011\u0011\u0004\u0005\u00079\u0015!\t%a\u0010\t\u000f\u0005]S\u0001\"\u0003\u0002Z!9\u0011QS\u0003\u0005\n\u0005]\u0005bBAc\u000b\u0011%\u0011q\u0019\u0005\b\u0005\u000b)A\u0011\u0002B\u0004\u0011\u001d\u0011)\"\u0002C\u0005\u0005/AqAa\u0007\u0006\t\u0013\u0011i\u0002C\u0004\u0003<\u0015!IA!\u0010\t\u000f\teS\u0001\"\u0003\u0003\\\u0005yq+\u001a2T_\u000e\\W\r\u001e*pkR,7O\u0003\u0002\u001d;\u00051!o\\;uKNT!AH\u0010\u0002\t)l\u0017\r\u001d\u0006\u0003A\u0005\nQA[1nKNT!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u0001\u0001CA\u0014\u0002\u001b\u0005Y\"aD,fEN{7m[3u%>,H/Z:\u0014\u0005\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002M\u00051AjT$H\u000bJ+\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003o\r\nQa\u001d7gi)L!!\u000f\u001c\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\u001a2!\u0002\u001fE!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aa\u00142kK\u000e$\bCA#G\u001b\u0005i\u0012BA$\u001e\u0005)QU*\u0011)S_V$Xm]\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\u0016\u0003)\u0003\"a\u0013(\u000e\u00031S!!T\u000f\u0002\t!$H\u000f]\u0005\u0003\u001f2\u0013Q\"Q;uQ\u0016tG/[2bi>\u0014\u0018AD1vi\",g\u000e^5dCR|'\u000fI\u0001\u0010kN,'\u000f\u0015:pm&\u001c\u0018n\u001c8feB\u00111jU\u0005\u0003)2\u0013\u0001#V:feB\u0013xN^5tS>t\u0017N\\4\u0002\u0011\u00154XM\u001c;CkN\u0004\"a\u0016.\u000e\u0003aS!!W\u0010\u0002\r\u00154XM\u001c;t\u0013\tY\u0006L\u0001\u0005Fm\u0016tGOQ;tQ\u0011IQ,\u001a4\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017AB5oU\u0016\u001cGOC\u0001c\u0003\u0015Q\u0017M^1y\u0013\t!wLA\u0003OC6,G-A\u0003wC2,X-I\u0001h\u0003\u0011QU*\u0011)\u0002\u000f)l\u0017\r]!qSB\u0011qE[\u0005\u0003Wn\u0011qAS'B!\u0006\u0003\u0018.A\fnC&d'm\u001c=DQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ssB\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0007G\"\fgnZ3\u000b\u0005Il\u0012aA1qS&\u0011Ao\u001c\u0002\u0018\u001b\u0006LGNY8y\u0007\"\fgnZ3SKB|7/\u001b;pef\fQ#Z7bS2\u001c\u0005.\u00198hKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002oo&\u0011\u0001p\u001c\u0002\u0016\u000b6\f\u0017\u000e\\\"iC:<WMU3q_NLGo\u001c:z\u00039\u0001Xo\u001d5TKJL\u0017\r\\5{KJ\u0004\"a\u001f@\u000e\u0003qT!!`\u000f\u0002\t)\u001cxN\\\u0005\u0003\u007fr\u0014a\u0002U;tQN+'/[1mSj,'/\u0001\tusB,7\u000b^1uK\u001a\u000b7\r^8ssB\u0019a.!\u0002\n\u0007\u0005\u001dqN\u0001\tUsB,7\u000b^1uK\u001a\u000b7\r^8ss\u0006yA-\u001a7fO\u0006$\u0018n\u001c8Ti>\u0014X\r\u0005\u0003\u0002\u000e\u0005UQBAA\b\u0015\r\u0011\u0018\u0011\u0003\u0006\u0004\u0003'y\u0012\u0001B;tKJLA!a\u0006\u0002\u0010\tyA)\u001a7fO\u0006$\u0018n\u001c8Ti>\u0014X\r\u0006\u000b\u0002\u001c\u0005u\u0011QEA\u0014\u0003W\ti#a\f\u00022\u0005M\u0012Q\u0007\t\u0003O\u0015AQ\u0001\u0013\tA\u0002)Cc!!\b^K\u0006\u0005\u0012EAA\u0012\u0003!\u0011fiQ\u00179mI\n\u0004\"B)\u0011\u0001\u0004\u0011\u0006\"B+\u0011\u0001\u00041\u0006&BA\u0014;\u00164\u0007\"\u00025\u0011\u0001\u0004I\u0007\"\u00027\u0011\u0001\u0004i\u0007\"B;\u0011\u0001\u00041\b\"B=\u0011\u0001\u0004Q\bbBA\u0001!\u0001\u0007\u00111\u0001\u0005\b\u0003\u0013\u0001\u0002\u0019AA\u0006Q\r\u0001\u0012\u0011\b\t\u0004=\u0006m\u0012bAA\u001f?\n1\u0011J\u001c6fGR$\"!!\u0011\u0011\r\u0005\r\u0013QJA)\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013AB:ue\u0016\fWNC\u0002\u0002L\u0001\u000bA!\u001e;jY&!\u0011qJA#\u0005\u0019\u0019FO]3b[B\u0019Q)a\u0015\n\u0007\u0005USDA\u0005K\u001b\u0006\u0003&k\\;uK\u0006\u0001\u0002.\u00198eY\u0016<VMY*pG.,Go\u001d\u000b\u0007\u00037\n)(a#\u0011\r\u0005u\u00131NA8\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014!\u00039vE2L7\u000f[3s\u0015\u0011\t)'a\u001a\u0002\t\r|'/\u001a\u0006\u0003\u0003S\nqA]3bGR|'/\u0003\u0003\u0002n\u0005}#\u0001B'p]>\u00042!PA9\u0013\r\t\u0019H\u0010\u0002\u0005->LG\rC\u0004\u0002xI\u0001\r!!\u001f\u0002#!$H\u000f]*feZ,'OU3rk\u0016\u001cH\u000f\u0005\u0003\u0002|\u0005\u001dUBAA?\u0015\u0011\ty(!!\u0002\rM,'O^3s\u0015\ri\u00151\u0011\u0006\u0005\u0003\u000b\u000b9'A\u0003oKR$\u00180\u0003\u0003\u0002\n\u0006u$!\u0005%uiB\u001cVM\u001d<feJ+\u0017/^3ti\"9\u0011Q\u0012\nA\u0002\u0005=\u0015A\u00055uiB\u001cVM\u001d<feJ+7\u000f]8og\u0016\u0004B!a\u001f\u0002\u0012&!\u00111SA?\u0005IAE\u000f\u001e9TKJ4XM\u001d*fgB|gn]3\u00023!\fg\u000e\u001a7f/\u0016\u00147k\\2lKR\u001cuN\u001c8fGRLwN\u001c\u000b\u0005\u00033\u000b)\f\u0006\u0004\u0002\\\u0005m\u00151\u0016\u0005\b\u0003;\u001b\u0002\u0019AAP\u0003\tIg\u000e\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\u0011\t)+!!\u0002\u0013],'m]8dW\u0016$\u0018\u0002BAU\u0003G\u0013\u0001cV3cg>\u001c7.\u001a;J]\n|WO\u001c3\t\u000f\u000556\u00031\u0001\u00020\u0006\u0019q.\u001e;\u0011\t\u0005\u0005\u0016\u0011W\u0005\u0005\u0003g\u000b\u0019KA\tXK\n\u001cxnY6fi>+HOY8v]\u0012Dq!a.\u0014\u0001\u0004\tI,A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0 \u0003\u001di\u0017-\u001b7c_bLA!a1\u0002>\nqQ*Y5mE>D8+Z:tS>t\u0017\u0001\u00065b]\u0012dWm\u00117jK:$X*Z:tC\u001e,7\u000f\u0006\u0003\u0002J\u0006mH\u0003BAf\u0003C\u0004b!!4\u0002T\u0006]WBAAh\u0015\u0011\t\t'!5\u000b\u00075\n\u0019'\u0003\u0003\u0002V\u0006='!B*N_:|\u0007\u0003BAm\u0003;l!!a7\u000b\u0007\u0005\u0015T$\u0003\u0003\u0002`\u0006m'aD(vi\n|WO\u001c3NKN\u001c\u0018mZ3\t\u000f\u0005\rH\u00031\u0001\u0002f\u00069Q.Z:tC\u001e,\u0007\u0003BAt\u0003ktA!!;\u0002rB\u0019\u00111\u001e\u0017\u000e\u0005\u00055(bAAxK\u00051AH]8pizJ1!a=-\u0003\u0019\u0001&/\u001a3fM&!\u0011q_A}\u0005\u0019\u0019FO]5oO*\u0019\u00111\u001f\u0017\t\u000f\u0005uH\u00031\u0001\u0002\u0000\u0006i1\r\\5f]R\u001cuN\u001c;fqR\u00042a\nB\u0001\u0013\r\u0011\u0019a\u0007\u0002\u000e\u00072LWM\u001c;D_:$X\r\u001f;\u00021M,g\u000e\u001a)vg\"\u001cF/\u0019;f\u0013\u001a\u0014V-];fgR,G\r\u0006\u0004\u0002L\n%!1\u0003\u0005\b\u0005\u0017)\u0002\u0019\u0001B\u0007\u0003)\u0001Xo\u001d5F]\u0006\u0014G.\u001a\t\u0005\u00033\u0014y!\u0003\u0003\u0003\u0012\u0005m'aE,fEN{7m[3u!V\u001c\b.\u00128bE2,\u0007bBA\u007f+\u0001\u0007\u0011q`\u0001\u000eg\u0016tG\rU;tQN#\u0018\r^3\u0015\t\u0005-'\u0011\u0004\u0005\b\u0003{4\u0002\u0019AA\u0000\u0003aA\u0017M\u001c3mK\"#H\u000f\u001d%b]\u0012\u001c\b.Y6f\u000bJ\u0014xN\u001d\u000b\u0007\u0005?\u0011\tCa\u000e\u0011\r\u00055\u00171[A8\u0011\u001d\u0011\u0019c\u0006a\u0001\u0005K\t\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\t\u001d\"\u0011\u0007\b\u0005\u0005S\u0011iC\u0004\u0003\u0002l\n-\u0012\"A\u0017\n\u0007\t=B&A\u0004qC\u000e\\\u0017mZ3\n\t\tM\"Q\u0007\u0002\n)\"\u0014xn^1cY\u0016T1Aa\f-\u0011\u001d\u0011Id\u0006a\u0001\u0003\u001f\u000b\u0001B]3ta>t7/Z\u0001\bCN,%O]8s)\u0011\u0011yD!\u0013\u0015\t\t\u0005#q\t\t\u0005\u00033\u0014\u0019%\u0003\u0003\u0003F\u0005m'AD,fEN{7m[3u\u000bJ\u0014xN\u001d\u0005\b\u0005GA\u0002\u0019\u0001B\u0013\u0011\u001d\u0011Y\u0005\u0007a\u0001\u0005\u001b\n\u0011B]3rk\u0016\u001cH/\u00133\u0011\u000b-\u0012yEa\u0015\n\u0007\tECF\u0001\u0004PaRLwN\u001c\t\u0005\u00033\u0014)&\u0003\u0003\u0003X\u0005m'!\u0003*fcV,7\u000f^%e\u00039\u0011Xm\u001d9p]\u0012$U\r^1jYN$bAa\b\u0003^\t}\u0003bBAG3\u0001\u0007\u0011q\u0012\u0005\b\u0005CJ\u0002\u0019\u0001B2\u0003\u001d!W\r^1jYN\u0004B!!7\u0003f%!!qMAn\u00059\u0001&o\u001c2mK6$U\r^1jYN\u0004")
public class WebSocketRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final JMAPApi jmapApi;
    private final MailboxChangeRepository mailboxChangeRepository;
    private final EmailChangeRepository emailChangeRepository;
    private final PushSerializer pushSerializer;
    private final TypeStateFactory typeStateFactory;
    private final DelegationStore delegationStore;

    public static Logger LOGGER() {
        return WebSocketRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.GET, (String)"/jmap/ws")).action((httpServerRequest, httpServerResponse) -> this.handleWebSockets(httpServerRequest, httpServerResponse)).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)"/jmap/ws")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleWebSockets(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(httpServerRequest)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(SMono$.MODULE$.apply((Publisher)httpServerResponse.sendWebsocket((in, out) -> this.handleWebSocketConnection((MailboxSession)mailboxSession, (WebsocketInbound)in, (WebsocketOutbound)out))))).onErrorResume((Function1 & Serializable)throwable -> this.handleHttpHandshakeError((Throwable)throwable, httpServerResponse)).asJava().then();
    }

    private Mono<Void> handleWebSocketConnection(MailboxSession session, WebsocketInbound in, WebsocketOutbound out) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        SFlux qual$1 = SFlux$.MODULE$.apply((Publisher)in.aggregateFrames().receiveFrames()).map((Function1 & Serializable)frame -> {
            byte[] bytes = new byte[frame.content().readableBytes()];
            frame.content().readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)message -> this.handleClientMessages(context, (String)message);
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SFlux responseFlux = qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> context.clean()).doOnCancel((Function0)(JFunction0.mcV.sp & Serializable)() -> context.clean());
        return out.sendString((Publisher)SFlux$.MODULE$.merge((Seq)new .colon.colon((Object)responseFlux, (List)new .colon.colon((Object)sink.asFlux(), (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).map((Function1 & Serializable)outboundMessage -> $this.pushSerializer.serialize((OutboundMessage)outboundMessage)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json))).then();
    }

    private SMono<OutboundMessage> handleClientMessages(ClientContext clientContext, String message) {
        return (SMono)this.pushSerializer.deserializeWebSocketInboundMessage(message).fold((Function1 & Serializable)invalid -> {
            WebSocketError error = this.asError((Option<RequestId>)None$.MODULE$, new IllegalArgumentException(invalid.toString()));
            return SMono$.MODULE$.just((Object)error);
        }, (Function1 & Serializable)x0$1 -> {
            WebSocketInboundMessage webSocketInboundMessage = x0$1;
            if (webSocketInboundMessage instanceof WebSocketRequest) {
                WebSocketRequest webSocketRequest = (WebSocketRequest)webSocketInboundMessage;
                return $this.jmapApi.process(webSocketRequest.requestObject(), clientContext.session()).map((Function1 & Serializable)x$1 -> new WebSocketResponse(webSocketRequest.id(), (ResponseObject)x$1)).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)this.asError(webSocketRequest.id(), (Throwable)e)));
            }
            if (webSocketInboundMessage instanceof WebSocketPushEnable) {
                WebSocketPushEnable webSocketPushEnable = (WebSocketPushEnable)webSocketInboundMessage;
                return SMono$.MODULE$.just((Object)clientContext.session().getUser()).concatWith((Publisher)SFlux$.MODULE$.fromPublisher($this.delegationStore.delegatedUsers(clientContext.session().getUser()))).map((Function1 & Serializable)username -> AccountIdRegistrationKey$.MODULE$.of((Username)username)).collectSeq().flatMap((Function1 & Serializable)keys -> SMono$.MODULE$.apply($this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener((Set<TypeName>)((Set)webSocketPushEnable.dataTypes().getOrElse((Function0 & Serializable)() -> $this.typeStateFactory.all().toSet())), clientContext.outbound()), CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)keys).asJavaCollection()))).doOnNext((Function1 & Serializable)newRegistration -> {
                    clientContext.withRegistration(newRegistration);
                    return BoxedUnit.UNIT;
                }).then(this.sendPushStateIfRequested(webSocketPushEnable, clientContext));
            }
            if (WebSocketPushDisable$.MODULE$.equals(webSocketInboundMessage)) {
                return SMono$.MODULE$.fromCallable(() -> {
                    clientContext.clean();
                    return BoxedUnit.UNIT;
                }).then(SMono$.MODULE$.empty());
            }
            throw new MatchError((Object)webSocketInboundMessage);
        });
    }

    private SMono<OutboundMessage> sendPushStateIfRequested(WebSocketPushEnable pushEnable, ClientContext clientContext) {
        return (SMono)pushEnable.pushState().map((Function1 & Serializable)x$2 -> this.sendPushState(clientContext)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
    }

    private SMono<OutboundMessage> sendPushState(ClientContext clientContext) {
        Username username = clientContext.session().getUser();
        org.apache.james.jmap.core.AccountId accountId = (org.apache.james.jmap.core.AccountId)AccountId$.MODULE$.from(username).fold((Function1 & Serializable)failure -> {
            throw new IllegalArgumentException((Throwable)failure);
        }, (Function1 & Serializable)success -> success);
        return SMono$.MODULE$.apply((Publisher)this.mailboxChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).flatMap(mailboxState -> $this.emailChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).map(emailState -> new StateChange((Map<org.apache.james.jmap.core.AccountId, TypeState>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)accountId), (Object)new TypeState((Map<TypeName, State>)((Map)MailboxTypeName$.MODULE$.asMap((Option<State>)new Some((Object)UuidState$.MODULE$.fromJava((org.apache.james.jmap.api.change.State)mailboxState))).$plus$plus(EmailTypeName$.MODULE$.asMap((Option<State>)new Some((Object)UuidState$.MODULE$.fromJava((org.apache.james.jmap.api.change.State)emailState)))))))}))), (Option<PushState>)new Some((Object)PushState$.MODULE$.from(new UuidState(mailboxState.getValue()), new UuidState(emailState.getValue())))))));
    }

    private SMono<Void> handleHttpHandshakeError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private WebSocketError asError(Option<RequestId> requestId, Throwable throwable) {
        return new WebSocketError(requestId, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    @Inject
    public WebSocketRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus, JMAPApi jmapApi, MailboxChangeRepository mailboxChangeRepository, EmailChangeRepository emailChangeRepository, PushSerializer pushSerializer, TypeStateFactory typeStateFactory, DelegationStore delegationStore) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
        this.jmapApi = jmapApi;
        this.mailboxChangeRepository = mailboxChangeRepository;
        this.emailChangeRepository = emailChangeRepository;
        this.pushSerializer = pushSerializer;
        this.typeStateFactory = typeStateFactory;
        this.delegationStore = delegationStore;
    }
}

