/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.TermsBucketBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class DoubleTermsBucket
extends TermsBucketBase {
    private final double key;
    @Nullable
    private final String keyAsString;
    public static final JsonpDeserializer<DoubleTermsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DoubleTermsBucket::setupDoubleTermsBucketDeserializer);

    private DoubleTermsBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
        this.keyAsString = builder.keyAsString;
    }

    public static DoubleTermsBucket of(Function<Builder, ObjectBuilder<DoubleTermsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double key() {
        return this.key;
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("key");
        generator.write(this.key);
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
    }

    protected static void setupDoubleTermsBucketDeserializer(ObjectDeserializer<Builder> op) {
        DoubleTermsBucket.setupTermsBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.doubleDeserializer(), "key");
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
    }

    public static class Builder
    extends TermsBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DoubleTermsBucket> {
        private Double key;
        @Nullable
        private String keyAsString;

        public final Builder key(double value) {
            this.key = value;
            return this;
        }

        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DoubleTermsBucket build() {
            this._checkSingleUse();
            return new DoubleTermsBucket(this);
        }
    }
}

