/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class HunspellTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final boolean dedup;
    private final String dictionary;
    private final String locale;
    private final boolean longestOnly;
    public static final JsonpDeserializer<HunspellTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HunspellTokenFilter::setupHunspellTokenFilterDeserializer);

    private HunspellTokenFilter(Builder builder) {
        super(builder);
        this.dedup = ApiTypeHelper.requireNonNull(builder.dedup, this, "dedup");
        this.dictionary = ApiTypeHelper.requireNonNull(builder.dictionary, this, "dictionary");
        this.locale = ApiTypeHelper.requireNonNull(builder.locale, this, "locale");
        this.longestOnly = ApiTypeHelper.requireNonNull(builder.longestOnly, this, "longestOnly");
    }

    public static HunspellTokenFilter of(Function<Builder, ObjectBuilder<HunspellTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Hunspell;
    }

    public final boolean dedup() {
        return this.dedup;
    }

    public final String dictionary() {
        return this.dictionary;
    }

    public final String locale() {
        return this.locale;
    }

    public final boolean longestOnly() {
        return this.longestOnly;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "hunspell");
        super.serializeInternal(generator, mapper);
        generator.writeKey("dedup");
        generator.write(this.dedup);
        generator.writeKey("dictionary");
        generator.write(this.dictionary);
        generator.writeKey("locale");
        generator.write(this.locale);
        generator.writeKey("longest_only");
        generator.write(this.longestOnly);
    }

    protected static void setupHunspellTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        HunspellTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::dedup, JsonpDeserializer.booleanDeserializer(), "dedup");
        op.add(Builder::dictionary, JsonpDeserializer.stringDeserializer(), "dictionary");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale");
        op.add(Builder::longestOnly, JsonpDeserializer.booleanDeserializer(), "longest_only");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HunspellTokenFilter> {
        private Boolean dedup;
        private String dictionary;
        private String locale;
        private Boolean longestOnly;

        public final Builder dedup(boolean value) {
            this.dedup = value;
            return this;
        }

        public final Builder dictionary(String value) {
            this.dictionary = value;
            return this;
        }

        public final Builder locale(String value) {
            this.locale = value;
            return this;
        }

        public final Builder longestOnly(boolean value) {
            this.longestOnly = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HunspellTokenFilter build() {
            this._checkSingleUse();
            return new HunspellTokenFilter(this);
        }
    }
}

