/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.snapshot.IndexDetails;
import org.opensearch.client.opensearch.snapshot.InfoFeatureState;
import org.opensearch.client.opensearch.snapshot.SnapshotShardFailure;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SnapshotInfo
implements PlainJsonSerializable {
    @Nonnull
    private final List<String> dataStreams;
    @Nullable
    private final Time duration;
    @Nullable
    private final String durationInMillis;
    @Nullable
    private final Time endTime;
    @Nullable
    private final String endTimeInMillis;
    @Nonnull
    private final List<SnapshotShardFailure> failures;
    @Nullable
    private final Boolean includeGlobalState;
    @Nonnull
    private final List<String> indices;
    @Nonnull
    private final Map<String, JsonData> metadata;
    @Nullable
    private final Long pinnedTimestamp;
    @Nullable
    private final String reason;
    @Nullable
    private final Boolean remoteStoreIndexShallowCopy;
    @Nullable
    private final ShardStatistics shards;
    @Nonnull
    private final String snapshot;
    @Nullable
    private final Time startTime;
    @Nullable
    private final String startTimeInMillis;
    @Nullable
    private final String state;
    @Nonnull
    private final String uuid;
    @Nullable
    private final String version;
    @Nullable
    private final Long versionId;
    public static final JsonpDeserializer<SnapshotInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotInfo::setupSnapshotInfoDeserializer);

    private SnapshotInfo(Builder builder) {
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
        this.duration = builder.duration;
        this.durationInMillis = builder.durationInMillis;
        this.endTime = builder.endTime;
        this.endTimeInMillis = builder.endTimeInMillis;
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.includeGlobalState = builder.includeGlobalState;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.pinnedTimestamp = builder.pinnedTimestamp;
        this.reason = builder.reason;
        this.remoteStoreIndexShallowCopy = builder.remoteStoreIndexShallowCopy;
        this.shards = builder.shards;
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.startTime = builder.startTime;
        this.startTimeInMillis = builder.startTimeInMillis;
        this.state = builder.state;
        this.uuid = ApiTypeHelper.requireNonNull(builder.uuid, this, "uuid");
        this.version = builder.version;
        this.versionId = builder.versionId;
    }

    public static SnapshotInfo of(Function<Builder, ObjectBuilder<SnapshotInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> dataStreams() {
        return this.dataStreams;
    }

    @Nullable
    public final Time duration() {
        return this.duration;
    }

    @Nullable
    public final String durationInMillis() {
        return this.durationInMillis;
    }

    @Nullable
    public final Time endTime() {
        return this.endTime;
    }

    @Nullable
    public final String endTimeInMillis() {
        return this.endTimeInMillis;
    }

    @Nonnull
    public final List<SnapshotShardFailure> failures() {
        return this.failures;
    }

    @Nullable
    public final Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    @Nonnull
    public final List<String> indices() {
        return this.indices;
    }

    @Deprecated
    public final Map<String, IndexDetails> indexDetails() {
        return Collections.emptyMap();
    }

    @Nonnull
    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final Long pinnedTimestamp() {
        return this.pinnedTimestamp;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Nullable
    public final Boolean remoteStoreIndexShallowCopy() {
        return this.remoteStoreIndexShallowCopy;
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Nonnull
    public final String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public final Time startTime() {
        return this.startTime;
    }

    @Nullable
    public final String startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final String state() {
        return this.state;
    }

    @Nonnull
    public final String uuid() {
        return this.uuid;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Nullable
    public final Long versionId() {
        return this.versionId;
    }

    @Deprecated
    public final List<InfoFeatureState> featureStates() {
        return Collections.emptyList();
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data_streams");
        generator.writeStartArray();
        for (String string : this.dataStreams) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.duration != null) {
            generator.writeKey("duration");
            this.duration.serialize(generator, mapper);
        }
        if (this.durationInMillis != null) {
            generator.writeKey("duration_in_millis");
            generator.write(this.durationInMillis);
        }
        if (this.endTime != null) {
            generator.writeKey("end_time");
            this.endTime.serialize(generator, mapper);
        }
        if (this.endTimeInMillis != null) {
            generator.writeKey("end_time_in_millis");
            generator.write(this.endTimeInMillis);
        }
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (SnapshotShardFailure snapshotShardFailure : this.failures) {
                snapshotShardFailure.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.includeGlobalState != null) {
            generator.writeKey("include_global_state");
            generator.write(this.includeGlobalState.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.pinnedTimestamp != null) {
            generator.writeKey("pinned_timestamp");
            generator.write(this.pinnedTimestamp.longValue());
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        if (this.remoteStoreIndexShallowCopy != null) {
            generator.writeKey("remote_store_index_shallow_copy");
            generator.write(this.remoteStoreIndexShallowCopy.booleanValue());
        }
        if (this.shards != null) {
            generator.writeKey("shards");
            this.shards.serialize(generator, mapper);
        }
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
        if (this.startTime != null) {
            generator.writeKey("start_time");
            this.startTime.serialize(generator, mapper);
        }
        if (this.startTimeInMillis != null) {
            generator.writeKey("start_time_in_millis");
            generator.write(this.startTimeInMillis);
        }
        if (this.state != null) {
            generator.writeKey("state");
            generator.write(this.state);
        }
        generator.writeKey("uuid");
        generator.write(this.uuid);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.versionId != null) {
            generator.writeKey("version_id");
            generator.write(this.versionId.longValue());
        }
    }

    protected static void setupSnapshotInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "data_streams");
        op.add(Builder::duration, Time._DESERIALIZER, "duration");
        op.add(Builder::durationInMillis, JsonpDeserializer.stringDeserializer(), "duration_in_millis");
        op.add(Builder::endTime, Time._DESERIALIZER, "end_time");
        op.add(Builder::endTimeInMillis, JsonpDeserializer.stringDeserializer(), "end_time_in_millis");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(SnapshotShardFailure._DESERIALIZER), "failures");
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::pinnedTimestamp, JsonpDeserializer.longDeserializer(), "pinned_timestamp");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::remoteStoreIndexShallowCopy, JsonpDeserializer.booleanDeserializer(), "remote_store_index_shallow_copy");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "shards");
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot");
        op.add(Builder::startTime, Time._DESERIALIZER, "start_time");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.stringDeserializer(), "start_time_in_millis");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::versionId, JsonpDeserializer.longDeserializer(), "version_id");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.dataStreams.hashCode();
        result = 31 * result + Objects.hashCode(this.duration);
        result = 31 * result + Objects.hashCode(this.durationInMillis);
        result = 31 * result + Objects.hashCode(this.endTime);
        result = 31 * result + Objects.hashCode(this.endTimeInMillis);
        result = 31 * result + Objects.hashCode(this.failures);
        result = 31 * result + Objects.hashCode(this.includeGlobalState);
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Objects.hashCode(this.pinnedTimestamp);
        result = 31 * result + Objects.hashCode(this.reason);
        result = 31 * result + Objects.hashCode(this.remoteStoreIndexShallowCopy);
        result = 31 * result + Objects.hashCode(this.shards);
        result = 31 * result + this.snapshot.hashCode();
        result = 31 * result + Objects.hashCode(this.startTime);
        result = 31 * result + Objects.hashCode(this.startTimeInMillis);
        result = 31 * result + Objects.hashCode(this.state);
        result = 31 * result + this.uuid.hashCode();
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.versionId);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInfo other = (SnapshotInfo)o;
        return this.dataStreams.equals(other.dataStreams) && Objects.equals(this.duration, other.duration) && Objects.equals(this.durationInMillis, other.durationInMillis) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.endTimeInMillis, other.endTimeInMillis) && Objects.equals(this.failures, other.failures) && Objects.equals(this.includeGlobalState, other.includeGlobalState) && Objects.equals(this.indices, other.indices) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.pinnedTimestamp, other.pinnedTimestamp) && Objects.equals(this.reason, other.reason) && Objects.equals(this.remoteStoreIndexShallowCopy, other.remoteStoreIndexShallowCopy) && Objects.equals(this.shards, other.shards) && this.snapshot.equals(other.snapshot) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.startTimeInMillis, other.startTimeInMillis) && Objects.equals(this.state, other.state) && this.uuid.equals(other.uuid) && Objects.equals(this.version, other.version) && Objects.equals(this.versionId, other.versionId);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SnapshotInfo> {
        private List<String> dataStreams;
        @Nullable
        private Time duration;
        @Nullable
        private String durationInMillis;
        @Nullable
        private Time endTime;
        @Nullable
        private String endTimeInMillis;
        @Nullable
        private List<SnapshotShardFailure> failures;
        @Nullable
        private Boolean includeGlobalState;
        @Nullable
        private List<String> indices;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Long pinnedTimestamp;
        @Nullable
        private String reason;
        @Nullable
        private Boolean remoteStoreIndexShallowCopy;
        @Nullable
        private ShardStatistics shards;
        private String snapshot;
        @Nullable
        private Time startTime;
        @Nullable
        private String startTimeInMillis;
        @Nullable
        private String state;
        private String uuid;
        @Nullable
        private String version;
        @Nullable
        private Long versionId;

        @Nonnull
        public final Builder dataStreams(List<String> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        @Nonnull
        public final Builder dataStreams(String value, String ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        @Nonnull
        public final Builder duration(@Nullable Time value) {
            this.duration = value;
            return this;
        }

        @Nonnull
        public final Builder duration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.duration(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder durationInMillis(@Nullable String value) {
            this.durationInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder endTime(@Nullable Time value) {
            this.endTime = value;
            return this;
        }

        @Nonnull
        public final Builder endTimeInMillis(@Nullable String value) {
            this.endTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder failures(List<SnapshotShardFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        @Nonnull
        public final Builder failures(SnapshotShardFailure value, SnapshotShardFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        @Nonnull
        public final Builder failures(Function<SnapshotShardFailure.Builder, ObjectBuilder<SnapshotShardFailure>> fn) {
            return this.failures(fn.apply(new SnapshotShardFailure.Builder()).build(), new SnapshotShardFailure[0]);
        }

        @Nonnull
        public final Builder includeGlobalState(@Nullable Boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        @Nonnull
        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Nonnull
        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        @Nonnull
        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Nonnull
        public final Builder pinnedTimestamp(@Nullable Long value) {
            this.pinnedTimestamp = value;
            return this;
        }

        @Nonnull
        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        @Nonnull
        public final Builder remoteStoreIndexShallowCopy(@Nullable Boolean value) {
            this.remoteStoreIndexShallowCopy = value;
            return this;
        }

        @Nonnull
        public final Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Nonnull
        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        @Nonnull
        public final Builder startTime(@Nullable Time value) {
            this.startTime = value;
            return this;
        }

        @Nonnull
        public final Builder startTimeInMillis(@Nullable String value) {
            this.startTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder state(@Nullable String value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public final Builder uuid(String value) {
            this.uuid = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder versionId(@Nullable Long value) {
            this.versionId = value;
            return this;
        }

        @Override
        @Nonnull
        public SnapshotInfo build() {
            this._checkSingleUse();
            return new SnapshotInfo(this);
        }
    }
}

