/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.POP3StreamResponse;
import org.apache.james.protocols.pop3.core.AbstractPOP3CommandHandler;
import org.apache.james.protocols.pop3.core.CRLFTerminatedInputStream;
import org.apache.james.protocols.pop3.core.ExtraDotInputStream;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.core.POP3MessageCommandArguments;
import org.apache.james.protocols.pop3.core.POP3MessageCommandDelegate;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.apache.james.util.MDCBuilder;

public class RetrCmdHandler
extends AbstractPOP3CommandHandler {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"RETR");
    private final MetricFactory metricFactory;
    private final POP3MessageCommandDelegate commandDelegate;

    @Inject
    public RetrCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
        this.commandDelegate = new POP3MessageCommandDelegate(COMMANDS){

            @Override
            protected Response handleMessageExists(POP3Session session, MessageMetaData data, POP3MessageCommandArguments args) throws IOException {
                InputStream content = RetrCmdHandler.this.getMessageContent(session, data);
                CRLFTerminatedInputStream in = new CRLFTerminatedInputStream(new ExtraDotInputStream(content));
                return new POP3StreamResponse("+OK", "Message follows", in);
            }
        };
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-retr", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("action", "RETR").addToContext(MDCConstants.withSession(session)).addToContext(MDCConstants.forRequest(request)), () -> this.commandDelegate.handleMessageRequest(session, request)));
    }

    protected InputStream getMessageContent(POP3Session session, MessageMetaData data) throws IOException {
        return session.getUserMailbox().getMessage(data.getUid());
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

