/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.ReactorUtils;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.apache.james.vault.metadata.MetadataSerializer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MetadataDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement removeStatement;
    private final PreparedStatement removeAllStatement;
    private final PreparedStatement readStatement;
    private final PreparedStatement readMessageIdStatement;
    private final MessageId.Factory messageIdFactory;
    private final MetadataSerializer metadataSerializer;

    @Inject
    MetadataDAO(CqlSession session, MessageId.Factory messageIdFactory, MetadataSerializer metadataSerializer) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAdd(session);
        this.removeStatement = this.prepareRemove(session);
        this.removeAllStatement = this.prepareRemoveAll(session);
        this.readStatement = this.prepareRead(session, "payload");
        this.readMessageIdStatement = this.prepareRead(session, "messageId");
        this.messageIdFactory = messageIdFactory;
        this.metadataSerializer = metadataSerializer;
    }

    private PreparedStatement prepareRead(CqlSession session, String fieldName) {
        return session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"deletedMessageMetadata").columns(new String[]{fieldName}).whereColumn("bucketName").isEqualTo((Term)QueryBuilder.bindMarker((String)"bucketName"))).whereColumn("owner").isEqualTo((Term)QueryBuilder.bindMarker((String)"owner"))).build());
    }

    private PreparedStatement prepareAdd(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"deletedMessageMetadata").value("bucketName", (Term)QueryBuilder.bindMarker((String)"bucketName")).value("owner", (Term)QueryBuilder.bindMarker((String)"owner")).value("messageId", (Term)QueryBuilder.bindMarker((String)"messageId")).value("payload", (Term)QueryBuilder.bindMarker((String)"payload")).build());
    }

    private PreparedStatement prepareRemove(CqlSession session) {
        return session.prepare(((Delete)((Delete)((Delete)QueryBuilder.deleteFrom((String)"deletedMessageMetadata").whereColumn("bucketName").isEqualTo((Term)QueryBuilder.bindMarker((String)"bucketName"))).whereColumn("owner").isEqualTo((Term)QueryBuilder.bindMarker((String)"owner"))).whereColumn("messageId").isEqualTo((Term)QueryBuilder.bindMarker((String)"messageId"))).build());
    }

    private PreparedStatement prepareRemoveAll(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"deletedMessageMetadata").whereColumn("bucketName").isEqualTo((Term)QueryBuilder.bindMarker((String)"bucketName"))).whereColumn("owner").isEqualTo((Term)QueryBuilder.bindMarker((String)"owner"))).build());
    }

    Mono<Void> store(DeletedMessageWithStorageInformation metadata) {
        return Mono.just((Object)metadata).map(arg_0 -> ((MetadataSerializer)this.metadataSerializer).serialize(arg_0)).flatMap(payload -> this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.addStatement.bind(new Object[0]).setString("bucketName", metadata.getStorageInformation().getBucketName().asString())).setString("owner", metadata.getDeletedMessage().getOwner().asString())).setString("messageId", metadata.getDeletedMessage().getMessageId().serialize())).setString("payload", payload)));
    }

    Flux<DeletedMessageWithStorageInformation> retrieveMetadata(BucketName bucketName, Username username) {
        return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)this.readStatement.bind(new Object[0]).setString("bucketName", bucketName.asString())).setString("owner", username.asString())).map(row -> row.getString("payload")).map(arg_0 -> ((MetadataSerializer)this.metadataSerializer).deserialize(arg_0)).handle(ReactorUtils.publishIfPresent());
    }

    Flux<MessageId> retrieveMessageIds(BucketName bucketName, Username username) {
        return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)this.readMessageIdStatement.bind(new Object[0]).setString("bucketName", bucketName.asString())).setString("owner", username.asString())).map(row -> row.getString("messageId")).map(arg_0 -> ((MessageId.Factory)this.messageIdFactory).fromString(arg_0));
    }

    Mono<Void> deleteMessage(BucketName bucketName, Username username, MessageId messageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.removeStatement.bind(new Object[0]).setString("bucketName", bucketName.asString())).setString("owner", username.asString())).setString("messageId", messageId.serialize()));
    }

    Mono<Void> deleteInBucket(BucketName bucketName, Username username) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.removeAllStatement.bind(new Object[0]).setString("bucketName", bucketName.asString())).setString("owner", username.asString()));
    }
}

