/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.util.DurationParser;

public class CassandraMailQueueViewConfiguration {
    private static final int DEFAULT_BUCKET_COUNT = 1;
    private static final Duration DEFAULT_SLICE_WINDOW = Duration.ofHours(1L);
    private static final int DEFAULT_UPDATE_BROWSE_START_PACE = 1000;
    public static final CassandraMailQueueViewConfiguration DEFAULT = CassandraMailQueueViewConfiguration.builder().bucketCount(1).updateBrowseStartPace(1000).sliceWindow(DEFAULT_SLICE_WINDOW).build();
    public static final String BUCKET_COUNT_PROPERTY = "mailqueue.view.bucketCount";
    public static final String UPDATE_BROWSE_START_PACE_PROPERTY = "mailqueue.view.updateBrowseStartPace";
    public static final String SLICE_WINDOW_PROPERTY = "mailqueue.view.sliceWindow";
    private final int bucketCount;
    private final int updateBrowseStartPace;
    private final Duration sliceWindow;

    public static Builder.RequireBucketCount builder() {
        return bucketCount -> updateBrowseStartPace -> sliceWindow -> new Builder.ReadyToBuild(bucketCount, updateBrowseStartPace, sliceWindow);
    }

    public static CassandraMailQueueViewConfiguration from(Configuration configuration) {
        int bucketCount = configuration.getInteger(BUCKET_COUNT_PROPERTY, Integer.valueOf(1));
        int updateBrowseStartPace = configuration.getInteger(UPDATE_BROWSE_START_PACE_PROPERTY, Integer.valueOf(1000));
        Optional<String> sliceWindowAsString = Optional.ofNullable(configuration.getString(SLICE_WINDOW_PROPERTY, null));
        return CassandraMailQueueViewConfiguration.builder().bucketCount(bucketCount).updateBrowseStartPace(updateBrowseStartPace).sliceWindow(sliceWindowAsString.map(DurationParser::parse).orElse(DEFAULT_SLICE_WINDOW)).build();
    }

    private CassandraMailQueueViewConfiguration(int bucketCount, int updateBrowseStartPace, Duration sliceWindow) {
        this.bucketCount = bucketCount;
        this.updateBrowseStartPace = updateBrowseStartPace;
        this.sliceWindow = sliceWindow;
    }

    public int getUpdateBrowseStartPace() {
        return this.updateBrowseStartPace;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public Duration getSliceWindow() {
        return this.sliceWindow;
    }

    void validateConfigurationChange(CassandraMailQueueViewConfiguration configurationUpdate) {
        this.validateConfigurationChangeForSlice(configurationUpdate);
        this.validateConfigurationChangeForBuckets(configurationUpdate);
    }

    private void validateConfigurationChangeForSlice(CassandraMailQueueViewConfiguration configurationUpdate) {
        long updateSliceWindowInSecond = configurationUpdate.getSliceWindow().getSeconds();
        long currentSliceWindowInSecond = this.getSliceWindow().getSeconds();
        Preconditions.checkArgument((configurationUpdate.getSliceWindow().compareTo(this.getSliceWindow()) <= 0 && currentSliceWindowInSecond % updateSliceWindowInSecond == 0L ? 1 : 0) != 0, (String)"update 'sliceWindow'(%s) have to be less than and divide the previous sliceWindow: %s", (Object)configurationUpdate.getSliceWindow(), (Object)this.getSliceWindow());
    }

    private void validateConfigurationChangeForBuckets(CassandraMailQueueViewConfiguration configurationUpdate) {
        Preconditions.checkArgument((configurationUpdate.getBucketCount() >= this.getBucketCount() ? 1 : 0) != 0, (String)"can not set 'bucketCount'(%s) to be less than the current one: %s", (int)configurationUpdate.getBucketCount(), (int)this.getBucketCount());
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraMailQueueViewConfiguration) {
            CassandraMailQueueViewConfiguration that = (CassandraMailQueueViewConfiguration)o;
            return Objects.equals(this.bucketCount, that.bucketCount) && Objects.equals(this.updateBrowseStartPace, that.updateBrowseStartPace) && Objects.equals(this.sliceWindow, that.sliceWindow);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.bucketCount, this.updateBrowseStartPace, this.sliceWindow);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucketCount", this.bucketCount).add("updateBrowseStartPace", this.updateBrowseStartPace).add("sliceWindow", (Object)this.sliceWindow).toString();
    }

    static interface Builder {

        public static class ReadyToBuild {
            private final int bucketCount;
            private final int updateBrowseStartPace;
            private final Duration sliceWindow;

            private ReadyToBuild(int bucketCount, int updateBrowseStartPace, Duration sliceWindow) {
                this.bucketCount = bucketCount;
                this.updateBrowseStartPace = updateBrowseStartPace;
                this.sliceWindow = sliceWindow;
            }

            public CassandraMailQueueViewConfiguration build() {
                Preconditions.checkNotNull((Object)this.sliceWindow, (Object)"'sliceWindow' is compulsory");
                Preconditions.checkState((this.bucketCount > 0 ? 1 : 0) != 0, (Object)"'bucketCount' needs to be a strictly positive integer");
                Preconditions.checkState((this.updateBrowseStartPace > 0 ? 1 : 0) != 0, (Object)"'updateBrowseStartPace' needs to be a strictly positive integer");
                return new CassandraMailQueueViewConfiguration(this.bucketCount, this.updateBrowseStartPace, this.sliceWindow);
            }
        }

        @FunctionalInterface
        public static interface RequireSliceWindow {
            public ReadyToBuild sliceWindow(Duration var1);
        }

        @FunctionalInterface
        public static interface RequireUpdateBrowseStartPace {
            public RequireSliceWindow updateBrowseStartPace(int var1);
        }

        @FunctionalInterface
        public static interface RequireBucketCount {
            public RequireUpdateBrowseStartPace bucketCount(int var1);
        }
    }
}

