/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.MailAddress;

public class Rule {
    private final Id id;
    private final String name;
    private final ConditionGroup conditionGroup;
    private final Action action;

    public static Builder builder() {
        return new Builder();
    }

    private Rule(Id id, String name, ConditionGroup conditionGroup, Action action) {
        this.id = id;
        this.name = name;
        this.conditionGroup = conditionGroup;
        this.action = action;
    }

    public Id getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ConditionGroup getConditionGroup() {
        return this.conditionGroup;
    }

    public Action getAction() {
        return this.action;
    }

    public final boolean equals(Object o) {
        if (o instanceof Rule) {
            Rule rule = (Rule)o;
            return Objects.equals(this.id, rule.id) && Objects.equals(this.name, rule.name) && Objects.equals(this.conditionGroup, rule.conditionGroup) && Objects.equals(this.action, rule.action);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.name, this.conditionGroup, this.action);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("conditionGroup", (Object)this.conditionGroup).add("action", (Object)this.action).toString();
    }

    public static class Builder {
        private Id id;
        private String name;
        private ConditionGroup conditionGroup;
        private Action action;

        public Builder id(Id id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder conditionGroup(Condition condition) {
            this.conditionGroup = ConditionGroup.of(condition);
            return this;
        }

        public Builder conditionGroup(ConditionGroup conditionGroup) {
            this.conditionGroup = conditionGroup;
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            return this;
        }

        public Builder action(Action.Builder action) {
            this.action = action.build();
            return this;
        }

        public Rule build() {
            Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"`id` is mandatory");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"`name` is mandatory");
            Preconditions.checkState((this.conditionGroup != null ? 1 : 0) != 0, (Object)"`conditions` is mandatory");
            Preconditions.checkState((this.action != null ? 1 : 0) != 0, (Object)"`action` is mandatory");
            return new Rule(this.id, this.name, this.conditionGroup, this.action);
        }
    }

    public static class Id {
        private final String value;

        public static Id of(String id) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"`id` is mandatory");
            return new Id(id);
        }

        private Id(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Id) {
                Id id = (Id)o;
                return Objects.equals(this.value, id.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }

    public static class ConditionGroup {
        private final ConditionCombiner conditionCombiner;
        private final List<Condition> conditions;

        public static ConditionGroup of(ConditionCombiner conditionCombiner, List<Condition> conditions) {
            return new ConditionGroup(conditionCombiner, conditions);
        }

        public static ConditionGroup of(ConditionCombiner conditionCombiner, Condition ... conditions) {
            return new ConditionGroup(conditionCombiner, (List<Condition>)ImmutableList.copyOf((Object[])conditions));
        }

        public static ConditionGroup of(Condition condition) {
            return ConditionGroup.of(ConditionCombiner.AND, condition);
        }

        private ConditionGroup(ConditionCombiner conditionCombiner, List<Condition> conditions) {
            this.conditionCombiner = conditionCombiner;
            this.conditions = conditions;
        }

        public ConditionCombiner getConditionCombiner() {
            return this.conditionCombiner;
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }

        public final boolean equals(Object o) {
            if (o instanceof ConditionGroup) {
                ConditionGroup other = (ConditionGroup)o;
                return Objects.equals((Object)this.conditionCombiner, (Object)other.conditionCombiner) && Objects.equals(this.conditions, other.conditions);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.conditionCombiner, this.conditions});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("conditionCombiner", (Object)this.conditionCombiner).add("conditions", this.conditions).toString();
        }
    }

    public static class Action {
        private final AppendInMailboxes appendInMailboxes;
        private final boolean markAsSeen;
        private final boolean markAsImportant;
        private final boolean reject;
        private final List<String> withKeywords;
        private final Optional<Forward> forward;

        public static Builder builder() {
            return new Builder();
        }

        public static Action of(AppendInMailboxes appendInMailboxes) {
            return new Action(appendInMailboxes, false, false, false, (List<String>)ImmutableList.of(), Optional.empty());
        }

        public static Action of(AppendInMailboxes appendInMailboxes, boolean markAsSeen, boolean markAsImportant, boolean reject, List<String> withKeywords) {
            return new Action(appendInMailboxes, markAsSeen, markAsImportant, reject, withKeywords, Optional.empty());
        }

        public static Action of(AppendInMailboxes appendInMailboxes, boolean markAsSeen, boolean markAsImportant, boolean reject, List<String> withKeywords, Optional<Forward> forward) {
            return new Action(appendInMailboxes, markAsSeen, markAsImportant, reject, withKeywords, forward);
        }

        private Action(AppendInMailboxes appendInMailboxes, boolean markAsSeen, boolean markAsImportant, boolean reject, List<String> withKeywords, Optional<Forward> forward) {
            this.appendInMailboxes = appendInMailboxes;
            this.markAsSeen = markAsSeen;
            this.markAsImportant = markAsImportant;
            this.reject = reject;
            this.withKeywords = withKeywords;
            this.forward = forward;
        }

        public AppendInMailboxes getAppendInMailboxes() {
            return this.appendInMailboxes;
        }

        public boolean isMarkAsSeen() {
            return this.markAsSeen;
        }

        public boolean isMarkAsImportant() {
            return this.markAsImportant;
        }

        public boolean isReject() {
            return this.reject;
        }

        public Collection<String> getWithKeywords() {
            return this.withKeywords;
        }

        public Optional<Forward> getForward() {
            return this.forward;
        }

        public final boolean equals(Object o) {
            if (o instanceof Action) {
                Action action = (Action)o;
                return Objects.equals(this.appendInMailboxes, action.appendInMailboxes) && Objects.equals(this.markAsSeen, action.markAsSeen) && Objects.equals(this.markAsImportant, action.markAsImportant) && Objects.equals(this.reject, action.reject) && Objects.equals(this.withKeywords, action.withKeywords) && Objects.equals(this.forward, action.forward);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.appendInMailboxes, this.markAsImportant, this.markAsSeen, this.reject, this.withKeywords, this.forward);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("appendInMailboxes", (Object)this.appendInMailboxes).add("markAsImportant", this.markAsImportant).add("markAsSeen", this.markAsSeen).add("reject", this.reject).add("withKeywords", this.withKeywords).add("forward", this.forward).toString();
        }

        public static class Builder {
            private AppendInMailboxes appendInMailboxes;
            private boolean markAsSeen;
            private boolean markAsImportant;
            private boolean reject;
            private List<String> withKeywords;
            private Optional<Forward> forward;

            public Builder setAppendInMailboxes(AppendInMailboxes appendInMailboxes) {
                this.appendInMailboxes = appendInMailboxes;
                return this;
            }

            public Builder setMarkAsSeen(boolean markAsSeen) {
                this.markAsSeen = markAsSeen;
                return this;
            }

            public Builder setMarkAsImportant(boolean markAsImportant) {
                this.markAsImportant = markAsImportant;
                return this;
            }

            public Builder setReject(boolean reject) {
                this.reject = reject;
                return this;
            }

            public Builder setWithKeywords(List<String> withKeywords) {
                this.withKeywords = withKeywords;
                return this;
            }

            public Builder setForward(Optional<Forward> forward) {
                this.forward = forward;
                return this;
            }

            public Builder setForward(Forward forward) {
                this.forward = Optional.of(forward);
                return this;
            }

            public Action build() {
                this.appendInMailboxes = Optional.ofNullable(this.appendInMailboxes).orElse(AppendInMailboxes.withMailboxIds((List<String>)ImmutableList.of()));
                this.withKeywords = Optional.ofNullable(this.withKeywords).orElse((List<String>)ImmutableList.of());
                this.forward = Optional.ofNullable(this.forward).orElse(Optional.empty());
                return new Action(this.appendInMailboxes, this.markAsSeen, this.markAsImportant, this.reject, this.withKeywords, this.forward);
            }
        }

        public static class AppendInMailboxes {
            private final ImmutableList<String> mailboxIds;

            public static AppendInMailboxes withMailboxIds(List<String> mailboxIds) {
                Preconditions.checkNotNull(mailboxIds, (Object)"mailboxIds should not be null");
                return new AppendInMailboxes(mailboxIds);
            }

            public static AppendInMailboxes withMailboxIds(String ... mailboxIds) {
                return AppendInMailboxes.withMailboxIds(Arrays.asList(mailboxIds));
            }

            private AppendInMailboxes(List<String> mailboxIds) {
                this.mailboxIds = ImmutableList.copyOf(mailboxIds);
            }

            public ImmutableList<String> getMailboxIds() {
                return this.mailboxIds;
            }

            public final boolean equals(Object o) {
                if (o instanceof AppendInMailboxes) {
                    AppendInMailboxes appendInMailboxes = (AppendInMailboxes)o;
                    return Objects.equals(this.mailboxIds, appendInMailboxes.mailboxIds);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.mailboxIds);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("mailboxIds", this.mailboxIds).toString();
            }
        }

        public static class Forward {
            private final ImmutableList<MailAddress> addresses;
            private final boolean keepACopy;

            public static RequireLocalCopy to(Collection<MailAddress> addresses) {
                return keepACopy -> new Forward((ImmutableList<MailAddress>)ImmutableList.copyOf((Collection)addresses), keepACopy);
            }

            public static RequireLocalCopy to(MailAddress ... addresses) {
                return keepACopy -> new Forward((ImmutableList<MailAddress>)ImmutableList.copyOf((Object[])addresses), keepACopy);
            }

            public static Forward of(List<MailAddress> addresses, boolean keepACopy) {
                return new Forward((ImmutableList<MailAddress>)ImmutableList.copyOf(addresses), keepACopy);
            }

            private Forward(ImmutableList<MailAddress> addresses, boolean keepACopy) {
                this.addresses = addresses;
                this.keepACopy = keepACopy;
            }

            public List<MailAddress> getAddresses() {
                return this.addresses;
            }

            public boolean isKeepACopy() {
                return this.keepACopy;
            }

            public final boolean equals(Object o) {
                if (o instanceof Forward) {
                    Forward forward = (Forward)o;
                    return Objects.equals(this.addresses, forward.addresses) && Objects.equals(this.keepACopy, forward.keepACopy);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.addresses, this.keepACopy);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("addresses", this.addresses).add("keepACopy", this.keepACopy).toString();
            }

            @FunctionalInterface
            public static interface RequireLocalCopy {
                public Forward keepACopy(boolean var1);

                default public Forward keepACopy() {
                    return this.keepACopy(true);
                }

                default public Forward withoutACopy() {
                    return this.keepACopy(false);
                }
            }
        }
    }

    public static enum ConditionCombiner {
        AND,
        OR;

    }

    public static class Condition {
        private final Field field;
        private final Comparator comparator;
        private final String value;

        public static Condition of(Field field, Comparator comparator, String value) {
            Preconditions.checkNotNull((Object)field, (Object)"field should not be null");
            Preconditions.checkNotNull((Object)((Object)comparator), (Object)"comparator should not be null");
            Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"value should not be empty");
            return new Condition(field, comparator, value);
        }

        private Condition(Field field, Comparator comparator, String value) {
            this.field = field;
            this.comparator = comparator;
            this.value = value;
        }

        public Field getField() {
            return this.field;
        }

        public Comparator getComparator() {
            return this.comparator;
        }

        public String getValue() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Condition) {
                Condition condition = (Condition)o;
                return Objects.equals(this.field, condition.field) && Objects.equals((Object)this.comparator, (Object)condition.comparator) && Objects.equals(this.value, condition.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.field, this.comparator, this.value});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("comparator", (Object)this.comparator).add("value", (Object)this.value).toString();
        }

        public static interface Field {
            public static Optional<Field> find(String fieldName) {
                return FixedField.find(fieldName).or(() -> CustomHeaderField.find(fieldName));
            }

            public static Field of(String fieldName) {
                return Field.find(fieldName).orElseThrow(() -> new IllegalArgumentException("'" + fieldName + "' is not a valid field name"));
            }

            public String asString();
        }

        public static enum Comparator {
            CONTAINS("contains"),
            NOT_CONTAINS("not-contains"),
            EXACTLY_EQUALS("exactly-equals"),
            NOT_EXACTLY_EQUALS("not-exactly-equals"),
            START_WITH("start-with");

            private final String comparatorName;

            public static Optional<Comparator> find(String comparatorName) {
                return Arrays.stream(Comparator.values()).filter(value -> value.comparatorName.equalsIgnoreCase(comparatorName)).findAny();
            }

            public static Comparator of(String comparatorName) {
                return Comparator.find(comparatorName).orElseThrow(() -> new IllegalArgumentException("'" + comparatorName + "' is not a valid comparator name"));
            }

            private Comparator(String comparator) {
                this.comparatorName = comparator;
            }

            public String asString() {
                return this.comparatorName;
            }
        }

        public record CustomHeaderField(String headerName) implements Field
        {
            public static final String PREFIX = "header:";

            public static Optional<Field> find(String fieldName) {
                if (fieldName.startsWith(PREFIX)) {
                    return Optional.of(new CustomHeaderField(fieldName.substring(PREFIX.length())));
                }
                return Optional.empty();
            }

            @Override
            public String asString() {
                return PREFIX + this.headerName;
            }
        }

        public record FixedField(String fieldName) implements Field
        {
            public static Field FROM = new FixedField("from");
            public static Field TO = new FixedField("to");
            public static Field CC = new FixedField("cc");
            public static Field SUBJECT = new FixedField("subject");
            public static Field RECIPIENT = new FixedField("recipient");
            public static final ImmutableList<Field> VALUES = ImmutableList.of((Object)FROM, (Object)TO, (Object)CC, (Object)SUBJECT, (Object)RECIPIENT);

            public static Optional<Field> find(String fieldName) {
                return VALUES.stream().filter(value -> value.asString().equalsIgnoreCase(fieldName)).findAny();
            }

            @Override
            public String asString() {
                return this.fieldName;
            }
        }
    }
}

