/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;

public final class Box {
    private final Point a;
    private final Point b;

    private Box(Point a, Point b) {
        this.a = Assert.requireNonNull(a, "point A must not be null");
        this.b = Assert.requireNonNull(b, "point B must not be null");
    }

    public static Box of(Point a, Point b) {
        return new Box(a, b);
    }

    public static Box of(double ax, double ay, double bx, double by) {
        return new Box(Point.of(ax, ay), Point.of(bx, by));
    }

    public Point getA() {
        return this.a;
    }

    public Point getB() {
        return this.b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Box box = (Box)o;
        return this.a.equals(box.a) && this.b.equals(box.b) || this.a.equals(box.b) && this.b.equals(box.a);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    public String toString() {
        return "(" + this.a + "," + this.b + ")";
    }
}

