/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.pushsubscription;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.backends.postgres.utils.PostgresUtils;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.DeviceClientIdInvalidException;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionId;
import org.apache.james.jmap.api.model.PushSubscriptionKeys;
import org.apache.james.jmap.api.model.PushSubscriptionServerURL;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.postgres.pushsubscription.PostgresPushSubscriptionDataDefinition;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Option;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class PostgresPushSubscriptionDAO {
    private static final Predicate<Throwable> IS_PRIMARY_KEY_UNIQUE_CONSTRAINT = throwable -> throwable.getMessage().contains("push_subscription_primary_key_constraint");
    private final PostgresExecutor postgresExecutor;
    private final TypeStateFactory typeStateFactory;

    public PostgresPushSubscriptionDAO(PostgresExecutor postgresExecutor, TypeStateFactory typeStateFactory) {
        this.postgresExecutor = postgresExecutor;
        this.typeStateFactory = typeStateFactory;
    }

    public Mono<Void> save(Username username, PushSubscription pushSubscription) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TABLE_NAME).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.USER, (Object)username.asString()).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.DEVICE_CLIENT_ID, (Object)pushSubscription.deviceClientId()).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ID, (Object)pushSubscription.id().value()).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.EXPIRES, (Object)pushSubscription.expires().value().toOffsetDateTime()).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TYPES, (Object)((String[])CollectionConverters.asJava((Seq)pushSubscription.types()).stream().map(TypeName::asString).toArray(String[]::new))).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.URL, (Object)pushSubscription.url().value().toString()).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.VERIFICATION_CODE, (Object)pushSubscription.verificationCode()).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.VALIDATED, (Object)pushSubscription.validated()).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ENCRYPT_PUBLIC_KEY, (Object)OptionConverters.toJava((Option)pushSubscription.keys().map(PushSubscriptionKeys::p256dh)).orElse(null)).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ENCRYPT_AUTH_SECRET, (Object)OptionConverters.toJava((Option)pushSubscription.keys().map(PushSubscriptionKeys::auth)).orElse(null)))).onErrorMap(PostgresUtils.UNIQUE_CONSTRAINT_VIOLATION_PREDICATE.and(IS_PRIMARY_KEY_UNIQUE_CONSTRAINT), e -> new DeviceClientIdInvalidException(pushSubscription.deviceClientId(), "deviceClientId must be unique"));
    }

    public Flux<PushSubscription> listByUsername(Username username) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TABLE_NAME).where(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.USER.eq((Object)username.asString())))).map(this::recordAsPushSubscription);
    }

    public Flux<PushSubscription> getByUsernameAndIds(Username username, Collection<PushSubscriptionId> ids) {
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        Function<Collection, Flux> queryPublisherFunction = idsMatching -> this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TABLE_NAME).where(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.USER.eq((Object)username.asString())).and(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ID.in((Collection)idsMatching.stream().map(PushSubscriptionId::value).collect(Collectors.toList()))))).map(this::recordAsPushSubscription);
        if (ids.size() <= 32) {
            return queryPublisherFunction.apply(ids);
        }
        return Flux.fromIterable((Iterable)Iterables.partition(ids, (int)32)).flatMap(queryPublisherFunction);
    }

    public Mono<Void> deleteByUsername(Username username) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TABLE_NAME).where(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.USER.eq((Object)username.asString()))));
    }

    public Mono<Void> deleteByUsernameAndId(Username username, PushSubscriptionId id) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TABLE_NAME).where(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.USER.eq((Object)username.asString())).and(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ID.eq((Object)id.value()))));
    }

    public Mono<Set<TypeName>> updateType(Username username, PushSubscriptionId id, Set<TypeName> newTypes) {
        Preconditions.checkNotNull(newTypes, (Object)"newTypes should not be null");
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.update(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TABLE_NAME).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TYPES, (Object)((String[])newTypes.stream().map(TypeName::asString).toArray(String[]::new))).where(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.USER.eq((Object)username.asString())).and(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ID.eq((Object)id.value())).returning(new SelectFieldOrAsterisk[]{PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TYPES}))).map(this::extractTypes);
    }

    public Mono<Boolean> updateValidated(Username username, PushSubscriptionId id, boolean validated) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.update(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TABLE_NAME).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.VALIDATED, (Object)validated).where(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.USER.eq((Object)username.asString())).and(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ID.eq((Object)id.value())).returning(new SelectFieldOrAsterisk[]{PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.VALIDATED}))).map(record -> (Boolean)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.VALIDATED));
    }

    public Mono<ZonedDateTime> updateExpireTime(Username username, PushSubscriptionId id, ZonedDateTime newExpire) {
        Preconditions.checkNotNull((Object)newExpire, (Object)"newExpire should not be null");
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.update(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TABLE_NAME).set(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.EXPIRES, (Object)newExpire.toOffsetDateTime()).where(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.USER.eq((Object)username.asString())).and(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ID.eq((Object)id.value())).returning(new SelectFieldOrAsterisk[]{PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.EXPIRES}))).map(record -> (ZonedDateTime)PostgresCommons.OFFSET_DATE_TIME_ZONED_DATE_TIME_FUNCTION.apply((OffsetDateTime)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.EXPIRES)));
    }

    private PushSubscription recordAsPushSubscription(Record record) {
        try {
            return new PushSubscription(new PushSubscriptionId((UUID)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ID)), (String)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.DEVICE_CLIENT_ID), (PushSubscriptionServerURL)PushSubscriptionServerURL.from((String)((String)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.URL))).get(), OptionConverters.toScala(Optional.ofNullable((String)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ENCRYPT_PUBLIC_KEY)).flatMap(key -> Optional.ofNullable((String)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.ENCRYPT_AUTH_SECRET)).map(secret -> new PushSubscriptionKeys(key, secret)))), (String)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.VERIFICATION_CODE), ((Boolean)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.VALIDATED)).booleanValue(), Optional.ofNullable((OffsetDateTime)record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.EXPIRES)).map(PostgresCommons.OFFSET_DATE_TIME_ZONED_DATE_TIME_FUNCTION).map(PushSubscriptionExpiredTime::new).get(), CollectionConverters.asScala(this.extractTypes(record)).toSeq());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing PushSubscription from database", e);
        }
    }

    private Set<TypeName> extractTypes(Record record) {
        return Arrays.stream((String[])record.get(PostgresPushSubscriptionDataDefinition.PushSubscriptionTable.TYPES)).map(string -> (TypeName)this.typeStateFactory.strictParse(string).right().get()).collect(Collectors.toSet());
    }
}

