/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.quota.model.QuotaThreshold;
import org.apache.james.mailbox.quota.model.QuotaThresholds;
import org.apache.james.util.DurationParser;

public class QuotaMailingListenerConfiguration {
    public static final String DEFAULT_BODY_TEMPLATE = "classpath://templates/QuotaThresholdMailBody.mustache";
    public static final String DEFAULT_SUBJECT_TEMPLATE = "classpath://templates/QuotaThresholdMailSubject.mustache";
    public static final RenderingInformation DEFAULT_RENDERING_INFORMATION = RenderingInformation.from(Optional.empty(), Optional.empty());
    public static final Duration DEFAULT_GRACE_PERIOD = Duration.ofDays(1L);
    private static final String DEFAULT_NAME = "default";
    private final ImmutableMap<QuotaThreshold, RenderingInformation> toRenderingInformation;
    private final QuotaThresholds thresholds;
    private final Duration gracePeriod;
    private final Optional<String> bodyTemplate;
    private final Optional<String> subjectTemplate;
    private final String name;

    public static QuotaMailingListenerConfiguration from(HierarchicalConfiguration<ImmutableNode> config) {
        return QuotaMailingListenerConfiguration.builder().addThresholds(QuotaMailingListenerConfiguration.readThresholds(config)).subjectTemplate(QuotaMailingListenerConfiguration.readSubjectTemplate(config)).bodyTemplate(QuotaMailingListenerConfiguration.readBodyTemplate(config)).gracePeriod(QuotaMailingListenerConfiguration.readGracePeriod(config)).name(QuotaMailingListenerConfiguration.readName(config)).build();
    }

    private static Optional<String> readName(HierarchicalConfiguration<ImmutableNode> config) {
        return Optional.ofNullable(config.getString("name", null));
    }

    private static Optional<String> readSubjectTemplate(HierarchicalConfiguration<ImmutableNode> config) {
        return Optional.ofNullable(config.getString("subjectTemplate", null));
    }

    private static Optional<String> readBodyTemplate(HierarchicalConfiguration<ImmutableNode> config) {
        return Optional.ofNullable(config.getString("bodyTemplate", null));
    }

    private static Optional<Duration> readGracePeriod(HierarchicalConfiguration<ImmutableNode> config) {
        return Optional.ofNullable(config.getString("gracePeriod", null)).map(string -> DurationParser.parse((String)string, (ChronoUnit)ChronoUnit.DAYS));
    }

    private static ImmutableMap<QuotaThreshold, RenderingInformation> readThresholds(HierarchicalConfiguration<ImmutableNode> config) {
        return (ImmutableMap)config.configurationsAt("thresholds.threshold").stream().map(node -> Pair.of((Object)node.getDouble("value"), (Object)RenderingInformation.from(Optional.ofNullable(node.getString("bodyTemplate")), Optional.ofNullable(node.getString("subjectTemplate"))))).collect(ImmutableMap.toImmutableMap(pair -> new QuotaThreshold((Double)pair.getLeft()), Pair::getRight));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QuotaMailingListenerConfiguration defaultConfiguration() {
        return QuotaMailingListenerConfiguration.builder().build();
    }

    private QuotaMailingListenerConfiguration(ImmutableMap<QuotaThreshold, RenderingInformation> toRenderingInformation, QuotaThresholds thresholds, Duration gracePeriod, Optional<String> bodyTemplate, Optional<String> subjectTemplate, String name) {
        this.toRenderingInformation = toRenderingInformation;
        this.thresholds = thresholds;
        this.gracePeriod = gracePeriod;
        this.bodyTemplate = bodyTemplate;
        this.subjectTemplate = subjectTemplate;
        this.name = name;
    }

    public QuotaThresholds getThresholds() {
        return this.thresholds;
    }

    public Duration getGracePeriod() {
        return this.gracePeriod;
    }

    public String getBodyTemplate(QuotaThreshold quotaThreshold) {
        return Optional.ofNullable((RenderingInformation)this.toRenderingInformation.get((Object)quotaThreshold)).flatMap(RenderingInformation::getBodyTemplate).or(() -> this.bodyTemplate).orElse(DEFAULT_BODY_TEMPLATE);
    }

    public String getSubjectTemplate(QuotaThreshold quotaThreshold) {
        return Optional.ofNullable((RenderingInformation)this.toRenderingInformation.get((Object)quotaThreshold)).flatMap(RenderingInformation::getSubjectTemplate).or(() -> this.subjectTemplate).orElse(DEFAULT_SUBJECT_TEMPLATE);
    }

    public String getName() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaMailingListenerConfiguration) {
            QuotaMailingListenerConfiguration that = (QuotaMailingListenerConfiguration)o;
            return Objects.equals(this.toRenderingInformation, that.toRenderingInformation) && Objects.equals(this.thresholds, that.thresholds) && Objects.equals(this.gracePeriod, that.gracePeriod) && Objects.equals(this.subjectTemplate, that.subjectTemplate) && Objects.equals(this.bodyTemplate, that.bodyTemplate) && Objects.equals(this.name, that.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.toRenderingInformation, this.thresholds, this.subjectTemplate, this.bodyTemplate, this.gracePeriod, this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("toRenderingInformation", this.toRenderingInformation).add("thresholds", (Object)this.thresholds).add("bodyTemplate", this.bodyTemplate).add("subjectTemplate", this.subjectTemplate).add("gracePeriod", (Object)this.gracePeriod).add("name", (Object)this.name).toString();
    }

    public static class Builder {
        private ImmutableList.Builder<QuotaThreshold> thresholds = ImmutableList.builder();
        private ImmutableMap.Builder<QuotaThreshold, RenderingInformation> toRenderingInformation = ImmutableMap.builder();
        private Optional<Duration> gradePeriod = Optional.empty();
        private Optional<String> bodyTemplate = Optional.empty();
        private Optional<String> subjectTemplate = Optional.empty();
        private Optional<String> name = Optional.empty();

        private Builder() {
        }

        public Builder addThreshold(QuotaThreshold quotaThreshold, RenderingInformation renderingInformation) {
            this.thresholds.add((Object)quotaThreshold);
            this.toRenderingInformation.put((Object)quotaThreshold, (Object)renderingInformation);
            return this;
        }

        public Builder addThreshold(QuotaThreshold quotaThreshold) {
            this.thresholds.add((Object)quotaThreshold);
            return this;
        }

        public Builder addThresholds(QuotaThreshold ... quotaThresholds) {
            Arrays.stream(quotaThresholds).forEach(this::addThreshold);
            return this;
        }

        public Builder addThresholds(Collection<QuotaThreshold> quotaThresholds) {
            quotaThresholds.forEach(this::addThreshold);
            return this;
        }

        public Builder addThresholds(ImmutableMap<QuotaThreshold, RenderingInformation> quotaThresholds) {
            quotaThresholds.forEach(this::addThreshold);
            return this;
        }

        public Builder gracePeriod(Duration duration) {
            this.gradePeriod = Optional.of(duration);
            return this;
        }

        public Builder bodyTemplate(String bodyTemplate) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bodyTemplate) ? 1 : 0) != 0, (Object)"Pass a non null/empty bodyTemplate");
            this.bodyTemplate = Optional.of(bodyTemplate);
            return this;
        }

        public Builder subjectTemplate(String subjectTemplate) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subjectTemplate) ? 1 : 0) != 0, (Object)"Pass a non null/empty subjectTemplate");
            this.subjectTemplate = Optional.of(subjectTemplate);
            return this;
        }

        public Builder bodyTemplate(Optional<String> bodyTemplate) {
            bodyTemplate.ifPresent(this::bodyTemplate);
            return this;
        }

        public Builder subjectTemplate(Optional<String> subjectTemplate) {
            subjectTemplate.ifPresent(this::subjectTemplate);
            return this;
        }

        public Builder gracePeriod(Optional<Duration> duration) {
            duration.ifPresent(this::gracePeriod);
            return this;
        }

        public Builder name(String name) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Pass a non null/empty name");
            this.name = Optional.of(name);
            return this;
        }

        public Builder name(Optional<String> name) {
            name.ifPresent(this::name);
            return this;
        }

        public QuotaMailingListenerConfiguration build() {
            return new QuotaMailingListenerConfiguration((ImmutableMap<QuotaThreshold, RenderingInformation>)this.toRenderingInformation.build(), new QuotaThresholds((List<QuotaThreshold>)this.thresholds.build()), this.gradePeriod.orElse(DEFAULT_GRACE_PERIOD), this.bodyTemplate, this.subjectTemplate, this.name.orElse(QuotaMailingListenerConfiguration.DEFAULT_NAME));
        }
    }

    static interface XmlKeys {
        public static final String SUBJECT_TEMPLATE = "subjectTemplate";
        public static final String BODY_TEMPLATE = "bodyTemplate";
        public static final String GRACE_PERIOD = "gracePeriod";
        public static final String THRESHOLDS = "thresholds.threshold";
        public static final String THRESHOLD_VALUE = "value";
        public static final String NAME = "name";
    }

    public static class RenderingInformation {
        private final Optional<String> bodyTemplate;
        private final Optional<String> subjectTemplate;

        public static RenderingInformation from(Optional<String> bodyTemplate, Optional<String> subjectTemplate) {
            return new RenderingInformation(bodyTemplate, subjectTemplate);
        }

        public static RenderingInformation from(String bodyTemplate, String subjectTemplate) {
            return RenderingInformation.from(Optional.of(bodyTemplate), Optional.of(subjectTemplate));
        }

        private RenderingInformation(Optional<String> bodyTemplate, Optional<String> subjectTemplate) {
            Preconditions.checkArgument((!bodyTemplate.equals(Optional.of("")) ? 1 : 0) != 0, (Object)"Pass a non empty bodyTemplate");
            Preconditions.checkArgument((!subjectTemplate.equals(Optional.of("")) ? 1 : 0) != 0, (Object)"Pass a non empty subjectTemplate");
            this.bodyTemplate = bodyTemplate;
            this.subjectTemplate = subjectTemplate;
        }

        public Optional<String> getBodyTemplate() {
            return this.bodyTemplate;
        }

        public Optional<String> getSubjectTemplate() {
            return this.subjectTemplate;
        }

        public final boolean equals(Object o) {
            if (o instanceof RenderingInformation) {
                RenderingInformation that = (RenderingInformation)o;
                return Objects.equals(this.bodyTemplate, that.bodyTemplate) && Objects.equals(this.subjectTemplate, that.subjectTemplate);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.bodyTemplate, this.subjectTemplate);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("bodyTemplate", this.bodyTemplate).add("subjectTemplate", this.subjectTemplate).toString();
        }
    }
}

