/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class MemoryStats
implements PlainJsonSerializable {
    @Nullable
    private final String resident;
    @Nullable
    private final Long residentInBytes;
    @Nullable
    private final String share;
    @Nullable
    private final Long shareInBytes;
    @Nullable
    private final String totalVirtual;
    @Nullable
    private final Long totalVirtualInBytes;
    @Nullable
    private final Long totalInBytes;
    @Nullable
    private final Long freeInBytes;
    @Nullable
    private final Long usedInBytes;
    public static final JsonpDeserializer<MemoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MemoryStats::setupMemoryStatsDeserializer);

    protected MemoryStats(AbstractBuilder<?> builder) {
        this.resident = ((AbstractBuilder)builder).resident;
        this.residentInBytes = ((AbstractBuilder)builder).residentInBytes;
        this.share = ((AbstractBuilder)builder).share;
        this.shareInBytes = ((AbstractBuilder)builder).shareInBytes;
        this.totalVirtual = ((AbstractBuilder)builder).totalVirtual;
        this.totalVirtualInBytes = ((AbstractBuilder)builder).totalVirtualInBytes;
        this.totalInBytes = ((AbstractBuilder)builder).totalInBytes;
        this.freeInBytes = ((AbstractBuilder)builder).freeInBytes;
        this.usedInBytes = ((AbstractBuilder)builder).usedInBytes;
    }

    public static MemoryStats memoryStatsOf(Function<Builder, ObjectBuilder<MemoryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String resident() {
        return this.resident;
    }

    @Nullable
    public final Long residentInBytes() {
        return this.residentInBytes;
    }

    @Nullable
    public final String share() {
        return this.share;
    }

    @Nullable
    public final Long shareInBytes() {
        return this.shareInBytes;
    }

    @Nullable
    public final String totalVirtual() {
        return this.totalVirtual;
    }

    @Nullable
    public final Long totalVirtualInBytes() {
        return this.totalVirtualInBytes;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    public final long freeInBytes() {
        return this.freeInBytes;
    }

    public final long usedInBytes() {
        return this.usedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.resident != null) {
            generator.writeKey("resident");
            generator.write(this.resident);
        }
        if (this.residentInBytes != null) {
            generator.writeKey("resident_in_bytes");
            generator.write(this.residentInBytes.longValue());
        }
        if (this.share != null) {
            generator.writeKey("share");
            generator.write(this.share);
        }
        if (this.shareInBytes != null) {
            generator.writeKey("share_in_bytes");
            generator.write(this.shareInBytes.longValue());
        }
        if (this.totalVirtual != null) {
            generator.writeKey("total_virtual");
            generator.write(this.totalVirtual);
        }
        if (this.totalVirtualInBytes != null) {
            generator.writeKey("total_virtual_in_bytes");
            generator.write(this.totalVirtualInBytes.longValue());
        }
        if (this.totalInBytes != null) {
            generator.writeKey("total_in_bytes");
            generator.write(this.totalInBytes.longValue());
        }
        if (this.freeInBytes != null) {
            generator.writeKey("free_in_bytes");
            generator.write(this.freeInBytes.longValue());
        }
        if (this.usedInBytes != null) {
            generator.writeKey("used_in_bytes");
            generator.write(this.usedInBytes.longValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMemoryStatsDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::resident, JsonpDeserializer.stringDeserializer(), "resident");
        op.add(AbstractBuilder::residentInBytes, JsonpDeserializer.longDeserializer(), "resident_in_bytes");
        op.add(AbstractBuilder::share, JsonpDeserializer.stringDeserializer(), "share");
        op.add(AbstractBuilder::shareInBytes, JsonpDeserializer.longDeserializer(), "share_in_bytes");
        op.add(AbstractBuilder::totalVirtual, JsonpDeserializer.stringDeserializer(), "total_virtual");
        op.add(AbstractBuilder::totalVirtualInBytes, JsonpDeserializer.longDeserializer(), "total_virtual_in_bytes");
        op.add(AbstractBuilder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
        op.add(AbstractBuilder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(AbstractBuilder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String resident;
        @Nullable
        private Long residentInBytes;
        @Nullable
        private String share;
        @Nullable
        private Long shareInBytes;
        @Nullable
        private String totalVirtual;
        @Nullable
        private Long totalVirtualInBytes;
        private Long totalInBytes;
        private Long freeInBytes;
        private Long usedInBytes;

        public final BuilderT resident(@Nullable String value) {
            this.resident = value;
            return this.self();
        }

        public final BuilderT residentInBytes(@Nullable Long value) {
            this.residentInBytes = value;
            return this.self();
        }

        public final BuilderT share(@Nullable String value) {
            this.share = value;
            return this.self();
        }

        public final BuilderT shareInBytes(@Nullable Long value) {
            this.shareInBytes = value;
            return this.self();
        }

        public final BuilderT totalVirtual(@Nullable String value) {
            this.totalVirtual = value;
            return this.self();
        }

        public final BuilderT totalVirtualInBytes(@Nullable Long value) {
            this.totalVirtualInBytes = value;
            return this.self();
        }

        public final BuilderT totalInBytes(long value) {
            this.totalInBytes = value;
            return this.self();
        }

        public final BuilderT freeInBytes(long value) {
            this.freeInBytes = value;
            return this.self();
        }

        public final BuilderT usedInBytes(long value) {
            this.usedInBytes = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<MemoryStats> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MemoryStats build() {
            this._checkSingleUse();
            return new MemoryStats(this);
        }
    }
}

