/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.droplists.postgres;

import java.util.UUID;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresDropListDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresDropListsTable.TABLE}).addIndex(new PostgresIndex[]{PostgresDropListsTable.IDX_OWNER_SCOPE_OWNER}).addIndex(new PostgresIndex[]{PostgresDropListsTable.IDX_OWNER_SCOPE_OWNER_DENIED_ENTITY}).build();

    public static interface PostgresDropListsTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"droplist");
        public static final Field<UUID> DROPLIST_ID = DSL.field((String)"droplist_id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<String> OWNER_SCOPE = DSL.field((String)"owner_scope", (DataType)SQLDataType.VARCHAR);
        public static final Field<String> OWNER = DSL.field((String)"owner", (DataType)SQLDataType.VARCHAR);
        public static final Field<String> DENIED_ENTITY_TYPE = DSL.field((String)"denied_entity_type", (DataType)SQLDataType.VARCHAR);
        public static final Field<String> DENIED_ENTITY = DSL.field((String)"denied_entity", (DataType)SQLDataType.VARCHAR);
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(DROPLIST_ID).column(OWNER_SCOPE).column(OWNER).column(DENIED_ENTITY_TYPE).column(DENIED_ENTITY).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{DROPLIST_ID}))).disableRowLevelSecurity().build();
        public static final PostgresIndex IDX_OWNER_SCOPE_OWNER = PostgresIndex.name((String)"idx_owner_scope_owner").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{OWNER_SCOPE, OWNER}));
        public static final PostgresIndex IDX_OWNER_SCOPE_OWNER_DENIED_ENTITY = PostgresIndex.name((String)"idx_owner_scope_owner_denied_entity").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{OWNER_SCOPE, OWNER, DENIED_ENTITY}));
    }
}

