/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.webadmin.service.DeleteUserDataService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeleteUsersDataOfDomainTask
implements Task {
    static final TaskType TYPE = TaskType.of((String)"DeleteUsersDataOfDomainTask");
    private static final int LOW_CONCURRENCY = 2;
    private static final int MAX_STORED_FAILED_USERS = 100;
    private final Domain domain;
    private final DeleteUserDataService deleteUserDataService;
    private final UsersRepository usersRepository;
    private final Context context;

    public DeleteUsersDataOfDomainTask(DeleteUserDataService deleteUserDataService, Domain domain, UsersRepository usersRepository) {
        this.deleteUserDataService = deleteUserDataService;
        this.domain = domain;
        this.usersRepository = usersRepository;
        this.context = new Context();
    }

    public Task.Result run() {
        return (Task.Result)Flux.from((Publisher)this.usersRepository.listUsersOfADomainReactive(this.domain)).flatMap(this.deleteUserData(), 2).reduce(Task::combine).switchIfEmpty(Mono.just((Object)Task.Result.COMPLETED)).block();
    }

    private Function<Username, Publisher<Task.Result>> deleteUserData() {
        return username -> this.deleteUserDataService.performer().deleteUserData((Username)username).then(Mono.fromCallable(() -> {
            this.context.increaseSuccessfulUsers();
            return Task.Result.COMPLETED;
        })).onErrorResume(error -> {
            LOGGER.error("Error when deleting data of user {}", (Object)username.asString(), error);
            this.context.increaseFailedUsers();
            if (this.context.failedUsers.size() < 100) {
                this.context.addFailedUser((Username)username);
            }
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(Clock.systemUTC().instant(), this.domain, this.context.getSuccessfulUsersCount(), this.context.getFailedUsersCount(), this.context.getFailedUsers()));
    }

    public Domain getDomain() {
        return this.domain;
    }

    @VisibleForTesting
    Context getContext() {
        return this.context;
    }

    static class Context {
        private final AtomicLong successfulUsersCount = new AtomicLong();
        private final AtomicLong failedUsersCount = new AtomicLong();
        private final Set<Username> failedUsers = ConcurrentHashMap.newKeySet();

        private void increaseSuccessfulUsers() {
            this.successfulUsersCount.incrementAndGet();
        }

        private void increaseFailedUsers() {
            this.failedUsersCount.incrementAndGet();
        }

        private void addFailedUser(Username username) {
            this.failedUsers.add(username);
        }

        public long getSuccessfulUsersCount() {
            return this.successfulUsersCount.get();
        }

        public long getFailedUsersCount() {
            return this.failedUsersCount.get();
        }

        public Set<Username> getFailedUsers() {
            return this.failedUsers;
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final Domain domain;
        private final long successfulUsersCount;
        private final long failedUsersCount;
        private final Set<Username> failedUsers;

        public AdditionalInformation(Instant timestamp, Domain domain, long successfulUsersCount, long failedUsersCount, Set<Username> failedUsers) {
            this.timestamp = timestamp;
            this.domain = domain;
            this.successfulUsersCount = successfulUsersCount;
            this.failedUsersCount = failedUsersCount;
            this.failedUsers = failedUsers;
        }

        public Domain getDomain() {
            return this.domain;
        }

        public long getSuccessfulUsersCount() {
            return this.successfulUsersCount;
        }

        public long getFailedUsersCount() {
            return this.failedUsersCount;
        }

        public Set<Username> getFailedUsers() {
            return this.failedUsers;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public final boolean equals(Object o) {
            if (o instanceof AdditionalInformation) {
                AdditionalInformation that = (AdditionalInformation)o;
                return Objects.equals(this.successfulUsersCount, that.successfulUsersCount) && Objects.equals(this.failedUsersCount, that.failedUsersCount) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.domain, that.domain);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.timestamp, this.domain, this.successfulUsersCount, this.failedUsersCount);
        }
    }
}

