/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.pushsubscription;

import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.apache.james.core.Disconnector;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.user.api.UsersRepository;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class PushSubscriptionDisconnector
implements Disconnector {
    private final UsersRepository usersRepository;
    private final PushSubscriptionRepository repository;

    @Inject
    public PushSubscriptionDisconnector(UsersRepository usersRepository, PushSubscriptionRepository repository) {
        this.usersRepository = usersRepository;
        this.repository = repository;
    }

    public void disconnect(Predicate<Username> username) {
        Flux.from((Publisher)this.usersRepository.listReactive()).filter(username).flatMap(this.repository::delete).then().block();
    }
}

