/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.ErrorBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J&\u0010#\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010\u00110$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "afterRotation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rectangle", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "segment", "", "aes", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "Companion", "ErrorBarLegendKeyElementFactory", "plot-base"})
@SourceDebugExtension(value={"SMAP\nErrorBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1549#2:168\n1620#2,3:169\n1549#2:172\n1620#2,3:173\n*S KotlinDebug\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom\n*L\n39#1:168\n39#1:169,3\n67#1:172\n67#1:173,3\n*E\n"})
public final class ErrorBarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    public static final boolean HANDLES_GROUPS = false;

    public ErrorBarGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
    }

    private final Aes<Double> afterRotation(Aes<Double> aes2) {
        return this.flipHelper.getEffectiveAes(aes2);
    }

    private final DoubleRectangle afterRotation(DoubleRectangle rectangle) {
        return this.flipHelper.flip(rectangle);
    }

    private final DoubleSegment afterRotation(DoubleSegment segment) {
        return this.flipHelper.flip(segment);
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new ErrorBarLegendKeyElementFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Aes[]{Aes.Companion.getY(), Aes.Companion.getXMIN(), Aes.Companion.getXMAX(), Aes.Companion.getHEIGHT()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> minAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> maxAes = this.afterRotation(Aes.Companion.getYMAX());
        Aes<Double> widthAes = this.afterRotation(Aes.Companion.getWIDTH());
        Iterable<DataPointAesthetics> dataPoints2 = GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), xAes, minAes, maxAes, widthAes);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.ERROR_BAR, ctx);
        for (DataPointAesthetics p : dataPoints2) {
            void $this$mapTo$iv$iv;
            Double d = p.get(xAes);
            Intrinsics.checkNotNull((Object)d);
            double x = ((Number)d).doubleValue();
            Double d2 = p.get(minAes);
            Intrinsics.checkNotNull((Object)d2);
            double ymin = ((Number)d2).doubleValue();
            Double d3 = p.get(maxAes);
            Intrinsics.checkNotNull((Object)d3);
            double ymax = ((Number)d3).doubleValue();
            Double d4 = p.get(widthAes);
            Intrinsics.checkNotNull((Object)d4);
            double width2 = ((Number)d4).doubleValue() * ctx.getResolution(xAes);
            double height = ymax - ymin;
            DoubleRectangle rect = new DoubleRectangle(x - width2 / (double)2, ymin, width2, height);
            Iterable $this$map$iv = ErrorBarGeom.Companion.errorBarShapeSegments(rect);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DoubleSegment doubleSegment = (DoubleSegment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.afterRotation((DoubleSegment)p0));
            }
            List segments = (List)destination$iv$iv;
            SvgGElement g = ErrorBarGeom.Companion.errorBarShape(segments, p, geomHelper);
            root.add((SvgNode)g);
        }
        Object[] objectArray = new Aes[]{minAes, maxAes};
        FlippableGeomHelper.buildHints$default(this.flipHelper, CollectionsKt.listOf((Object[])objectArray), aesthetics2, pos, coord, ctx, this.clientRectByDataPoint(ctx, geomHelper), buildIntern.1.INSTANCE, colorsByDataPoint, null, 256, null);
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx, GeomHelper geomHelper) {
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(this, ctx, geomHelper){
            final /* synthetic */ ErrorBarGeom this$0;
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ GeomHelper $geomHelper;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$geomHelper = $geomHelper;
                super(1);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                DoubleRectangle doubleRectangle;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Aes xAes = ErrorBarGeom.access$afterRotation(this.this$0, Aes.Companion.getX());
                Aes minAes = ErrorBarGeom.access$afterRotation(this.this$0, Aes.Companion.getYMIN());
                Aes maxAes = ErrorBarGeom.access$afterRotation(this.this$0, Aes.Companion.getYMAX());
                Aes widthAes = ErrorBarGeom.access$afterRotation(this.this$0, Aes.Companion.getWIDTH());
                if (p.defined(xAes) && p.defined(minAes) && p.defined(maxAes) && p.defined(widthAes)) {
                    DoubleRectangle rect;
                    T t = p.get(xAes);
                    Intrinsics.checkNotNull(t);
                    double x = ((Number)t).doubleValue();
                    T t2 = p.get(minAes);
                    Intrinsics.checkNotNull(t2);
                    double ymin = ((Number)t2).doubleValue();
                    T t3 = p.get(maxAes);
                    Intrinsics.checkNotNull(t3);
                    double ymax = ((Number)t3).doubleValue();
                    T t4 = p.get(widthAes);
                    Intrinsics.checkNotNull(t4);
                    double width2 = ((Number)t4).doubleValue() * this.$ctx.getResolution(xAes);
                    double height = ymax - ymin;
                    DoubleRectangle doubleRectangle2 = this.$geomHelper.toClient(ErrorBarGeom.access$afterRotation(this.this$0, new DoubleRectangle(x - width2 / 2.0, ymin - height / 2.0, width2, 0.0)), p);
                    Intrinsics.checkNotNull((Object)doubleRectangle2);
                    doubleRectangle = rect = doubleRectangle2;
                } else {
                    doubleRectangle = null;
                }
                return doubleRectangle;
            }
        };
    }

    public static final /* synthetic */ Aes access$afterRotation(ErrorBarGeom $this, Aes aes2) {
        return $this.afterRotation(aes2);
    }

    public static final /* synthetic */ DoubleRectangle access$afterRotation(ErrorBarGeom $this, DoubleRectangle rectangle) {
        return $this.afterRotation(rectangle);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "errorBarLegendShape", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "segments", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "errorBarShape", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "errorBarShapeSegments", "r", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nErrorBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1855#2,2:168\n1855#2,2:170\n*S KotlinDebug\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$Companion\n*L\n129#1:168,2\n156#1:170,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final SvgGElement errorBarLegendShape(List<DoubleSegment> segments, DataPointAesthetics p) {
            SvgGElement g = new SvgGElement();
            Iterable $this$forEach$iv = segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DoubleSegment segment = (DoubleSegment)element$iv;
                boolean bl = false;
                SvgLineElement shapeLine = new SvgLineElement(segment.getStart().getX(), segment.getStart().getY(), segment.getEnd().getX(), segment.getEnd().getY());
                GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)shapeLine, p, false, null, 12, null);
                g.children().add((Object)shapeLine);
            }
            return g;
        }

        private final List<DoubleSegment> errorBarShapeSegments(DoubleRectangle r) {
            double center = r.getLeft() + r.getWidth() / (double)2;
            DoubleRectangle $this$errorBarShapeSegments_u24lambda_u241 = r;
            boolean bl = false;
            Object[] objectArray = new DoubleSegment[]{new DoubleSegment(new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getLeft(), $this$errorBarShapeSegments_u24lambda_u241.getTop()), new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getRight(), $this$errorBarShapeSegments_u24lambda_u241.getTop())), new DoubleSegment(new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getLeft(), $this$errorBarShapeSegments_u24lambda_u241.getBottom()), new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getRight(), $this$errorBarShapeSegments_u24lambda_u241.getBottom())), new DoubleSegment(new DoubleVector(center, $this$errorBarShapeSegments_u24lambda_u241.getTop()), new DoubleVector(center, $this$errorBarShapeSegments_u24lambda_u241.getBottom()))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final SvgGElement errorBarShape(List<DoubleSegment> segments, DataPointAesthetics p, GeomHelper geomHelper) {
            SvgGElement g = new SvgGElement();
            GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
            elementHelper.setStrokeAlphaEnabled(true);
            Iterable $this$forEach$iv = segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DoubleSegment segment = (DoubleSegment)element$iv;
                boolean bl = false;
                ObservableList observableList = g.children();
                SvgLineElement svgLineElement = GeomHelper.SvgElementHelper.createLine$default(elementHelper, segment.getStart(), segment.getEnd(), p, null, 8, null);
                Intrinsics.checkNotNull((Object)svgLineElement);
                observableList.add((Object)svgLineElement);
            }
            return g;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$ErrorBarLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "()V", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
    public static final class ErrorBarLegendKeyElementFactory
    implements LegendKeyElementFactory {
        @Override
        @NotNull
        public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
            Double d = p.width();
            Intrinsics.checkNotNull((Object)d);
            double width2 = d * (size.getX() - strokeWidth);
            double height = size.getY() - strokeWidth;
            double x = (size.getX() - width2) / (double)2;
            double y = strokeWidth / (double)2;
            return Companion.errorBarLegendShape(Companion.errorBarShapeSegments(new DoubleRectangle(x, y, width2, height)), p);
        }

        @Override
        @NotNull
        public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
            return LegendKeyElementFactory.DefaultImpls.minimumKeySize(this, p);
        }
    }
}

