/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.node.Node;
import java.util.ArrayList;
import java.util.List;

public class CreateArrayNode<T>
extends Node<T> {
    private final List<Expression<T>> entries;

    public CreateArrayNode(Adapter<T> runtime, List<? extends Expression<T>> entries) {
        super(runtime);
        this.entries = new ArrayList<Expression<T>>(entries);
    }

    @Override
    public T search(T input) {
        if (this.runtime.typeOf(input) == JmesPathType.NULL) {
            return input;
        }
        ArrayList<T> array = new ArrayList<T>(this.entries.size());
        for (Expression<T> entry : this.entries) {
            array.add(entry.search(input));
        }
        return (T)this.runtime.createArray(array);
    }

    @Override
    protected String internalToString() {
        if (this.entries.isEmpty()) {
            return "[]";
        }
        StringBuilder str = new StringBuilder("[");
        for (Expression<T> entry : this.entries) {
            str.append(entry).append(", ");
        }
        str.setLength(str.length() - 2);
        return str.append(']').toString();
    }

    @Override
    protected boolean internalEquals(Object o) {
        CreateArrayNode other = (CreateArrayNode)o;
        return this.entries.equals(other.entries);
    }

    @Override
    protected int internalHashCode() {
        int h = 1;
        for (Expression<T> node : this.entries) {
            h = h * 31 + node.hashCode();
        }
        return h;
    }
}

