/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.node.Node;
import java.util.Arrays;
import java.util.List;

public abstract class OperatorNode<T>
extends Node<T> {
    private final List<Expression<T>> operands;

    @SafeVarargs
    public OperatorNode(Adapter<T> runtime, Expression<T> ... operands) {
        super(runtime);
        this.operands = Arrays.asList(operands);
    }

    protected Expression<T> operand(int index) {
        return this.operands.get(index);
    }

    @Override
    protected String internalToString() {
        if (this.operands.isEmpty()) {
            return "";
        }
        StringBuilder operandsString = new StringBuilder();
        for (Expression<T> operand : this.operands) {
            operandsString.append(operand).append(", ");
        }
        operandsString.setLength(operandsString.length() - 2);
        return operandsString.toString();
    }

    @Override
    protected boolean internalEquals(Object o) {
        OperatorNode other = (OperatorNode)o;
        return this.operands.equals(other.operands);
    }

    @Override
    protected int internalHashCode() {
        int h = 1;
        for (Expression<T> node : this.operands) {
            h = h * 31 + node.hashCode();
        }
        return h;
    }
}

