/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.SteppingNode;

public abstract class SteppingNavigator {
    static SteppingNode getFollowingNode(SteppingNode start, SteppingNode anchor) {
        SteppingNode nodei = start.getFirstChild();
        if (nodei != null) {
            return nodei;
        }
        if (start.isSameNodeInfo(anchor)) {
            return null;
        }
        nodei = start;
        SteppingNode parenti = start.getParent();
        do {
            if ((nodei = nodei.getNextSibling()) != null) {
                return nodei;
            }
            if (parenti.isSameNodeInfo(anchor)) {
                return null;
            }
            nodei = parenti;
        } while ((parenti = parenti.getParent()) != null);
        return null;
    }

    public static class DescendantAxisIterator
    implements AxisIterator {
        private final SteppingNode start;
        private SteppingNode current;
        private boolean done;
        private final Stepper stepper;

        public DescendantAxisIterator(SteppingNode start, boolean includeSelf, NodeTest test) {
            this.start = start;
            if (!includeSelf || !test.test(start)) {
                this.current = start;
            }
            if (test == null || test == AnyNodeTest.getInstance()) {
                this.stepper = new FollowingNodeStepper(start);
            } else if (test instanceof NameTest) {
                if (((NameTest)test).getPrimitiveType() == 1) {
                    NameTest nt = (NameTest)test;
                    this.stepper = start.hasFingerprint() ? new FollowingFingerprintedElementStepper(start, nt.getFingerprint()) : new FollowingElementStepper(start, nt.getNamespaceURI(), nt.getLocalPart());
                } else {
                    this.stepper = new FollowingFilteredNodeStepper(start, test);
                }
            } else if (test instanceof NodeKindTest) {
                this.stepper = ((NodeKindTest)test).getPrimitiveType() == 1 ? new FollowingElementStepper(start, null, null) : new FollowingFilteredNodeStepper(start, test);
            } else if (test instanceof LocalNameTest) {
                if (((LocalNameTest)test).getPrimitiveType() == 1) {
                    LocalNameTest nt = (LocalNameTest)test;
                    this.stepper = new FollowingElementStepper(start, null, nt.getLocalName());
                } else {
                    this.stepper = new FollowingFilteredNodeStepper(start, test);
                }
            } else if (test instanceof NamespaceTest) {
                if (((NamespaceTest)test).getPrimitiveType() == 1) {
                    NamespaceTest nt = (NamespaceTest)test;
                    this.stepper = new FollowingElementStepper(start, nt.getNamespaceURI(), null);
                } else {
                    this.stepper = new FollowingFilteredNodeStepper(start, test);
                }
            } else {
                this.stepper = new FollowingFilteredNodeStepper(start, test);
            }
        }

        @Override
        public SteppingNode next() {
            if (this.done) {
                return null;
            }
            if (this.current == null) {
                this.current = this.start;
                return this.start;
            }
            SteppingNode curr = this.stepper.step(this.current);
            if (curr == null) {
                this.done = true;
            }
            this.current = curr;
            return this.current;
        }
    }

    private static class FollowingFingerprintedElementStepper
    implements Stepper {
        SteppingNode anchor;
        int fingerprint;

        FollowingFingerprintedElementStepper(SteppingNode anchor, int fingerprint) {
            this.anchor = anchor;
            this.fingerprint = fingerprint;
        }

        @Override
        public SteppingNode step(SteppingNode node) {
            while ((node = SteppingNavigator.getFollowingNode(node, this.anchor)) != null && node.getFingerprint() != this.fingerprint) {
            }
            return node;
        }
    }

    private static class FollowingElementStepper
    implements Stepper {
        SteppingNode anchor;
        String uri;
        String local;

        FollowingElementStepper(SteppingNode anchor, String uri, String local) {
            this.anchor = anchor;
            this.uri = uri;
            this.local = local;
        }

        @Override
        public SteppingNode step(SteppingNode node) {
            return node.getSuccessorElement(this.anchor, this.uri, this.local);
        }
    }

    private static class FollowingFilteredNodeStepper
    implements Stepper {
        SteppingNode anchor;
        NodeTest test;

        FollowingFilteredNodeStepper(SteppingNode anchor, NodeTest test) {
            this.anchor = anchor;
            this.test = test;
        }

        @Override
        public SteppingNode step(SteppingNode node) {
            while ((node = SteppingNavigator.getFollowingNode(node, this.anchor)) != null && !this.test.test(node)) {
            }
            return node;
        }
    }

    private static class FollowingNodeStepper
    implements Stepper {
        SteppingNode anchor;

        FollowingNodeStepper(SteppingNode anchor) {
            this.anchor = anchor;
        }

        @Override
        public SteppingNode step(SteppingNode node) {
            return SteppingNavigator.getFollowingNode(node, this.anchor);
        }
    }

    private static interface Stepper {
        public SteppingNode step(SteppingNode var1);
    }
}

