/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.BSFTestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BSFAssertion
extends BSFTestElement
implements Cloneable,
Assertion,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(BSFAssertion.class);
    private static final long serialVersionUID = 235L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        BSFManager mgr = null;
        try {
            mgr = this.getManager();
            mgr.declareBean("SampleResult", (Object)response, SampleResult.class);
            mgr.declareBean("AssertionResult", (Object)result, AssertionResult.class);
            this.processFileOrScript(mgr);
            result.setError(false);
        }
        catch (BSFException e) {
            log.warn("Problem in BSF script", (Throwable)e);
            result.setFailure(true);
            result.setError(true);
            result.setFailureMessage(e.toString());
        }
        finally {
            if (mgr != null) {
                mgr.terminate();
            }
        }
        return result;
    }

    public Object clone() {
        return super.clone();
    }
}

