/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.canvas;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.canvas.AwtCanvas;
import org.jetbrains.letsPlot.awt.canvas.AwtContext2d;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.core.canvas.FontStyle;
import org.jetbrains.letsPlot.core.canvas.FontWeight;
import org.jetbrains.letsPlot.core.canvas.LineCap;
import org.jetbrains.letsPlot.core.canvas.LineJoin;
import org.jetbrains.letsPlot.core.canvas.TextAlign;
import org.jetbrains.letsPlot.core.canvas.TextBaseline;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 k2\u00020\u0001:\u0002klB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J8\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0016J \u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J0\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000fH\u0016JP\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000fH\u0016J\b\u0010+\u001a\u00020\rH\u0016J\b\u0010,\u001a\u00020\rH\u0016J(\u0010-\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000fH\u0016J \u00100\u001a\u00020\r2\u0006\u00101\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u00103\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u000202H\u0016J\u0018\u00106\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u00107\u001a\u00020\rH\u0016J\u0010\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\u000fH\u0016J\b\u0010:\u001a\u00020\rH\u0016J\u0010\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u000fH\u0016J\u0018\u0010;\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010=\u001a\u00020\r2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020\u000fH\u0016J\u0010\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\r2\u0006\u0010O\u001a\u00020\u000fH\u0016J\u0012\u0010P\u001a\u00020\r2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010Q\u001a\u00020\r2\u0006\u0010R\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\r2\u0006\u0010U\u001a\u00020VH\u0016J8\u0010W\u001a\u00020\r2\u0006\u0010X\u001a\u00020\u000f2\u0006\u0010Y\u001a\u00020\u000f2\u0006\u0010Z\u001a\u00020\u000f2\u0006\u0010[\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0016J\b\u0010\\\u001a\u00020\rH\u0016J(\u0010]\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000fH\u0016J \u0010^\u001a\u00020\r2\u0006\u00101\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J \u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J8\u0010c\u001a\u00020\r2\u0006\u0010X\u001a\u00020\u000f2\u0006\u0010Y\u001a\u00020\u000f2\u0006\u0010Z\u001a\u00020\u000f2\u0006\u0010[\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0016J\u0018\u0010d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001c\u0010e\u001a\u00020f*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0014\u0010a\u001a\u00020b*\u00020\u00032\u0006\u00105\u001a\u000202H\u0002J>\u0010g\u001a\u00020\r*\u00020\u00032\u0006\u00101\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0018\u0010h\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020j\u0012\u0004\u0012\u00020\r0iH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtContext2d;", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "graphics", "Ljava/awt/Graphics2D;", "(Ljava/awt/Graphics2D;)V", "currentPath", "Ljava/awt/geom/GeneralPath;", "stack", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/awt/canvas/AwtContext2d$ContextState;", "Lkotlin/collections/ArrayList;", "state", "arc", "", "x", "", "y", "radius", "startAngle", "endAngle", "anticlockwise", "", "beginPath", "bezierCurveTo", "cp1x", "cp1y", "cp2x", "cp2y", "clearRect", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "closePath", "drawImage", "snapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "dw", "dh", "sx", "sy", "sw", "sh", "dx", "dy", "fill", "fillEvenOdd", "fillRect", "w", "h", "fillText", "text", "", "lineTo", "measureText", "str", "moveTo", "restore", "rotate", "angle", "save", "scale", "xy", "setFillStyle", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "setFont", "f", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "setGlobalAlpha", "alpha", "setLineCap", "lineCap", "Lorg/jetbrains/letsPlot/core/canvas/LineCap;", "setLineDash", "lineDash", "", "setLineJoin", "lineJoin", "Lorg/jetbrains/letsPlot/core/canvas/LineJoin;", "setLineWidth", "lineWidth", "setStrokeStyle", "setTextAlign", "align", "Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "setTextBaseline", "baseline", "Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;", "setTransform", "m11", "m12", "m21", "m22", "stroke", "strokeRect", "strokeText", "textPosition", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "glyphVector", "Ljava/awt/font/GlyphVector;", "transform", "translate", "applyTransform", "Ljava/awt/geom/Point2D;", "paintText", "painter", "Lkotlin/Function2;", "Ljava/awt/Shape;", "Companion", "ContextState", "platf-awt"})
@SourceDebugExtension(value={"SMAP\nAwtContext2d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwtContext2d.kt\norg/jetbrains/letsPlot/awt/canvas/AwtContext2d\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,402:1\n1#2:403\n11125#3:404\n11460#3,3:405\n*S KotlinDebug\n*F\n+ 1 AwtContext2d.kt\norg/jetbrains/letsPlot/awt/canvas/AwtContext2d\n*L\n327#1:404\n327#1:405,3\n*E\n"})
public final class AwtContext2d
implements Context2d {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Graphics2D graphics;
    @NotNull
    private GeneralPath currentPath;
    @NotNull
    private ContextState state;
    @NotNull
    private final ArrayList<ContextState> stack;

    public AwtContext2d(@NotNull Graphics2D graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        this.graphics = graphics;
        this.currentPath = new GeneralPath();
        this.state = new ContextState(null, null, null, null, null, null, 0.0f, null, 255, null);
        this.stack = new ArrayList();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D graphics2D = this.graphics;
        Map p0 = renderingHints;
        boolean bl = false;
        graphics2D.setRenderingHints(p0);
        this.graphics.setBackground(AwtContext2d.Companion.toAwtColor(org.jetbrains.letsPlot.commons.values.Color.Companion.getTRANSPARENT()));
        this.setLineCap(LineCap.BUTT);
    }

    private final Point2D applyTransform(ContextState $this$applyTransform, double x, double y) {
        Point2D point2D = $this$applyTransform.getTransform().transform(new Point2D.Double(x, y), null);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"transform(...)");
        return point2D;
    }

    private final GlyphVector glyphVector(Graphics2D $this$glyphVector, String str) {
        GlyphVector glyphVector = $this$glyphVector.getFont().createGlyphVector($this$glyphVector.getFontRenderContext(), str);
        Intrinsics.checkNotNullExpressionValue((Object)glyphVector, (String)"createGlyphVector(...)");
        return glyphVector;
    }

    private final void paintText(Graphics2D $this$paintText, String text, double x, double y, Function2<? super Graphics2D, ? super Shape, Unit> painter) {
        GlyphVector gv = this.glyphVector($this$paintText, text);
        DoubleVector position = this.textPosition(gv, x, y);
        AffineTransform savedTransform = $this$paintText.getTransform();
        $this$paintText.translate(position.getX(), position.getY());
        Shape shape = gv.getOutline();
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"getOutline(...)");
        painter.invoke((Object)$this$paintText, (Object)shape);
        $this$paintText.setTransform(savedTransform);
    }

    private final DoubleVector textPosition(GlyphVector glyphVector, double x, double y) {
        double d;
        double d2;
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"getVisualBounds(...)");
        Rectangle2D box = rectangle2D;
        FontMetrics fm = this.graphics.getFontMetrics();
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.getTextAlign().ordinal()]) {
            case 1: {
                d2 = x;
                break;
            }
            case 2: {
                d2 = x - box.getWidth() / (double)2;
                break;
            }
            case 3: {
                d2 = x - box.getWidth();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double offsetX = d2;
        switch (WhenMappings.$EnumSwitchMapping$1[this.state.getTextBaseline().ordinal()]) {
            case 1: {
                d = y;
                break;
            }
            case 2: {
                d = y - (double)fm.getDescent();
                break;
            }
            case 3: {
                d = y + (double)((fm.getLeading() + fm.getAscent() - fm.getDescent()) / 2);
                break;
            }
            case 4: {
                d = y + (double)fm.getLeading() + (double)fm.getAscent();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double offsetY = d;
        return new DoubleVector(offsetX, offsetY);
    }

    public void clearRect(@NotNull DoubleRectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.graphics.clearRect((int)rect.getLeft(), (int)rect.getTop(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    public void drawImage(@NotNull Canvas.Snapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.drawImage(snapshot, 0.0, 0.0);
    }

    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AwtCanvas.AwtSnapshot awtSnapshot = (AwtCanvas.AwtSnapshot)snapshot;
        this.graphics.drawImage((Image)awtSnapshot.getImage(), (int)x, (int)y, null);
    }

    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x, double y, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AwtCanvas.AwtSnapshot awtSnapshot = (AwtCanvas.AwtSnapshot)snapshot;
        this.graphics.drawImage(awtSnapshot.getImage(), (int)x, (int)y, (int)dw, (int)dh, null);
    }

    public void drawImage(@NotNull Canvas.Snapshot snapshot, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AwtCanvas.AwtSnapshot awtSnapshot = (AwtCanvas.AwtSnapshot)snapshot;
        this.graphics.drawImage(awtSnapshot.getImage(), (int)dx, (int)dy, (int)dw + (int)dx, (int)dh + (int)dy, (int)sx, (int)sy, (int)sw + (int)sx, (int)sh + (int)sy, null);
    }

    public void beginPath() {
        this.currentPath = new GeneralPath();
    }

    public void closePath() {
        this.currentPath.closePath();
    }

    public void stroke() {
        this.graphics.setColor(this.state.getStrokeColor());
        AwtContext2d.Companion.strokePath(this.graphics, this.currentPath);
    }

    public void fill() {
        this.graphics.setColor(this.state.getFillColor());
        AwtContext2d.Companion.fillPath(this.graphics, this.currentPath);
    }

    public void fillEvenOdd() {
        this.currentPath.setWindingRule(0);
        this.graphics.setColor(this.state.getFillColor());
        AwtContext2d.Companion.fillPath(this.graphics, this.currentPath);
    }

    public void fillRect(double x, double y, double w, double h) {
        this.graphics.setColor(this.state.getFillColor());
        this.graphics.fillRect((int)x, (int)y, (int)w, (int)h);
    }

    public void moveTo(double x, double y) {
        Point2D p = this.applyTransform(this.state, x, y);
        this.currentPath.moveTo(p.getX(), p.getY());
    }

    public void lineTo(double x, double y) {
        Point2D p = this.applyTransform(this.state, x, y);
        this.currentPath.lineTo(p.getX(), p.getY());
    }

    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        double trCp1x = 0.0;
        double trCp1y = 0.0;
        Point2D it = this.applyTransform(this.state, cp1x, cp1y);
        boolean bl = false;
        trCp1x = it.getX();
        trCp1y = it.getY();
        double trCp2x = 0.0;
        double trCp2y = 0.0;
        Point2D it2 = this.applyTransform(this.state, cp2x, cp2y);
        boolean bl2 = false;
        trCp2x = it2.getX();
        trCp2y = it2.getY();
        double trX = 0.0;
        double trY = 0.0;
        Point2D it3 = this.applyTransform(this.state, x, y);
        boolean bl3 = false;
        trX = it3.getX();
        trY = it3.getY();
        this.currentPath.curveTo(trCp1x, trCp1y, trCp2x, trCp2y, trX, trY);
    }

    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        double start2 = MathKt.toDegrees((double)startAngle) % (double)360;
        double end = MathKt.toDegrees((double)endAngle) % (double)360;
        double length = 0.0;
        if (start2 == end && !(startAngle == endAngle)) {
            length = 360.0;
        } else {
            if (start2 > end && end < 0.0) {
                end += (double)360;
            } else if (start2 > end && end >= 0.0) {
                start2 -= (double)360;
            }
            length = end - start2;
        }
        if (anticlockwise && !(length == 0.0) && !(length == 360.0)) {
            length -= (double)360;
        }
        Arc2D.Double arc = new Arc2D.Double(x - radius, y - radius, radius * (double)2, radius * (double)2, -start2, -length, 0);
        Path2D.Double path = new Path2D.Double(arc, this.graphics.getTransform());
        this.currentPath.append(path, true);
    }

    public void save() {
        this.stack.add(ContextState.copy$default(this.state, null, null, null, null, null, null, 0.0f, null, 255, null));
    }

    public void restore() {
        block0: {
            ContextState contextState = (ContextState)CollectionsKt.lastOrNull((List)this.stack);
            if (contextState == null) break block0;
            ContextState it = contextState;
            boolean bl = false;
            this.state = it;
            this.graphics.setTransform(this.state.getTransform());
            this.graphics.setStroke(this.state.getStroke());
            this.graphics.setFont(this.state.getFont());
            this.graphics.setComposite(AlphaComposite.getInstance(3, this.state.getGlobalAlpha()));
            this.stack.remove(CollectionsKt.getLastIndex((List)this.stack));
        }
    }

    public void setFillStyle(@Nullable org.jetbrains.letsPlot.commons.values.Color color) {
        Object object = color;
        if (object == null || (object = AwtContext2d.Companion.toAwtColor(object)) == null) {
            Color color2 = Color.BLACK;
            object = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BLACK");
        }
        this.state.setFillColor((Color)object);
    }

    public void setStrokeStyle(@Nullable org.jetbrains.letsPlot.commons.values.Color color) {
        Object object = color;
        if (object == null || (object = AwtContext2d.Companion.toAwtColor(object)) == null) {
            Color color2 = Color.BLACK;
            object = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BLACK");
        }
        this.state.setStrokeColor((Color)object);
    }

    public void setGlobalAlpha(double alpha) {
        this.state.setGlobalAlpha((float)alpha);
        this.graphics.setComposite(AlphaComposite.getInstance(3, this.state.getGlobalAlpha()));
    }

    public void setFont(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.state.setFont(AwtContext2d.Companion.toAwtFont(f));
        this.graphics.setFont(this.state.getFont());
    }

    public void setLineWidth(double lineWidth) {
        this.state.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.change$default(Companion, this.state.getStroke(), (float)lineWidth, 0, 0, 0.0f, null, 0.0f, 62, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public void strokeRect(double x, double y, double w, double h) {
        this.graphics.setColor(this.state.getStrokeColor());
        this.graphics.drawRect((int)x, (int)y, (int)w, (int)h);
    }

    public void strokeText(@NotNull String text, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.graphics.setColor(this.state.getStrokeColor());
        this.paintText(this.graphics, text, x, y, (Function2<? super Graphics2D, ? super Shape, Unit>)((Function2)strokeText.1.INSTANCE));
    }

    public void fillText(@NotNull String text, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.graphics.setColor(this.state.getFillColor());
        this.paintText(this.graphics, text, x, y, (Function2<? super Graphics2D, ? super Shape, Unit>)((Function2)fillText.1.INSTANCE));
    }

    public void scale(double xy) {
        this.scale(xy, xy);
    }

    public void scale(double x, double y) {
        this.graphics.scale(x, y);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    public void rotate(double angle) {
        this.graphics.rotate(angle);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    public void translate(double x, double y) {
        this.graphics.translate(x, y);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.graphics.transform(new AffineTransform(m11, m12, m21, m22, dx, dy));
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    public void setLineJoin(@NotNull LineJoin lineJoin) {
        Intrinsics.checkNotNullParameter((Object)lineJoin, (String)"lineJoin");
        this.state.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.change$default(Companion, this.state.getStroke(), 0.0f, AwtContext2d.Companion.convertLineJoin(lineJoin), 0, 0.0f, null, 0.0f, 61, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public void setLineCap(@NotNull LineCap lineCap) {
        Intrinsics.checkNotNullParameter((Object)lineCap, (String)"lineCap");
        this.state.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.change$default(Companion, this.state.getStroke(), 0.0f, 0, AwtContext2d.Companion.convertLineCap(lineCap), 0.0f, null, 0.0f, 59, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public void setTextBaseline(@NotNull TextBaseline baseline) {
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        this.state.setTextBaseline(baseline);
    }

    public void setTextAlign(@NotNull TextAlign align) {
        Intrinsics.checkNotNullParameter((Object)align, (String)"align");
        this.state.setTextAlign(align);
    }

    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.graphics.setTransform(new AffineTransform(m11, m12, m21, m22, dx, dy));
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    /*
     * WARNING - void declaration
     */
    public void setLineDash(@NotNull double[] lineDash) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)lineDash, (String)"lineDash");
        ContextState contextState = this.state;
        Companion companion = Companion;
        BasicStroke basicStroke = this.state.getStroke();
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        float f2 = 0.0f;
        if (lineDash.length == 0) {
            fArray = null;
        } else {
            Collection<Float> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            double[] dArray = lineDash;
            float f3 = f2;
            int n3 = n2;
            int n4 = n;
            float f4 = f;
            BasicStroke basicStroke2 = basicStroke;
            Companion companion2 = companion;
            ContextState contextState2 = contextState;
            boolean $i$f$map = false;
            void var4_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n5 = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n5; ++i) {
                void p0;
                void item$iv$iv;
                void var11_17 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf((float)p0));
            }
            collection = (List)destination$iv$iv;
            contextState = contextState2;
            companion = companion2;
            basicStroke = basicStroke2;
            f = f4;
            n = n4;
            n2 = n3;
            f2 = f3;
            fArray = CollectionsKt.toFloatArray((Collection)collection);
        }
        contextState.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.change$default(companion, basicStroke, f, n, n2, f2, fArray, 0.0f, 47, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public double measureText(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.glyphVector(this.graphics, str).getVisualBounds().getWidth();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002JJ\u0010\n\u001a\u00020\u000b*\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\rH\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J.\u0010\u0019\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00150\u001bH\u0002J\u0014\u0010\u001d\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002J\f\u0010!\u001a\u00020\"*\u00020#H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtContext2d$Companion;", "", "()V", "convertLineCap", "", "lineCap", "Lorg/jetbrains/letsPlot/core/canvas/LineCap;", "convertLineJoin", "lineJoin", "Lorg/jetbrains/letsPlot/core/canvas/LineJoin;", "change", "Ljava/awt/BasicStroke;", "width", "", "join", "cap", "miterlimit", "dash", "", "dashPhase", "fillPath", "", "Ljava/awt/Graphics2D;", "path", "Ljava/awt/geom/Path2D;", "paintPath", "painter", "Lkotlin/Function2;", "Ljava/awt/Shape;", "strokePath", "toAwtColor", "Ljava/awt/Color;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "toAwtFont", "Ljava/awt/Font;", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "platf-awt"})
    private static final class Companion {
        private Companion() {
        }

        private final void paintPath(Graphics2D $this$paintPath, Path2D path, Function2<? super Graphics2D, ? super Shape, Unit> painter) {
            AffineTransform currentTransform = $this$paintPath.getTransform();
            $this$paintPath.setTransform(new AffineTransform());
            painter.invoke((Object)$this$paintPath, (Object)path);
            $this$paintPath.setTransform(currentTransform);
        }

        private final void fillPath(Graphics2D $this$fillPath, Path2D path) {
            this.paintPath($this$fillPath, path, (Function2<? super Graphics2D, ? super Shape, Unit>)((Function2)fillPath.1.INSTANCE));
        }

        private final void strokePath(Graphics2D $this$strokePath, Path2D path) {
            this.paintPath($this$strokePath, path, (Function2<? super Graphics2D, ? super Shape, Unit>)((Function2)strokePath.1.INSTANCE));
        }

        private final Color toAwtColor(org.jetbrains.letsPlot.commons.values.Color $this$toAwtColor) {
            return new Color($this$toAwtColor.getRed(), $this$toAwtColor.getGreen(), $this$toAwtColor.getBlue(), $this$toAwtColor.getAlpha());
        }

        private final java.awt.Font toAwtFont(Font $this$toAwtFont) {
            int n;
            int n2;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toAwtFont.getFontWeight().ordinal()]) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int weight = n2;
            switch (WhenMappings.$EnumSwitchMapping$1[$this$toAwtFont.getFontStyle().ordinal()]) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int style = n;
            return new java.awt.Font($this$toAwtFont.getFontFamily(), weight | style, (int)$this$toAwtFont.getFontSize());
        }

        private final int convertLineJoin(LineJoin lineJoin) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$2[lineJoin.ordinal()]) {
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 0;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        private final int convertLineCap(LineCap lineCap) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$3[lineCap.ordinal()]) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        private final BasicStroke change(BasicStroke $this$change, float width, int join, int cap, float miterlimit, float[] dash, float dashPhase) {
            return new BasicStroke(width, cap, join, miterlimit, dash, dashPhase);
        }

        static /* synthetic */ BasicStroke change$default(Companion companion, BasicStroke basicStroke, float f, int n, int n2, float f2, float[] fArray, float f3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                f = basicStroke.getLineWidth();
            }
            if ((n3 & 2) != 0) {
                n = basicStroke.getLineJoin();
            }
            if ((n3 & 4) != 0) {
                n2 = basicStroke.getEndCap();
            }
            if ((n3 & 8) != 0) {
                f2 = basicStroke.getMiterLimit();
            }
            if ((n3 & 0x10) != 0) {
                fArray = basicStroke.getDashArray();
            }
            if ((n3 & 0x20) != 0) {
                f3 = basicStroke.getDashPhase();
            }
            return companion.change(basicStroke, f, n, n2, f2, fArray, f3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;

            static {
                int[] nArray = new int[FontWeight.values().length];
                try {
                    nArray[FontWeight.NORMAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FontWeight.BOLD.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[FontStyle.values().length];
                try {
                    nArray[FontStyle.NORMAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FontStyle.ITALIC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[LineJoin.values().length];
                try {
                    nArray[LineJoin.BEVEL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineJoin.MITER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineJoin.ROUND.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[LineCap.values().length];
                try {
                    nArray[LineCap.BUTT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineCap.ROUND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineCap.SQUARE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$3 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001BU\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0006H\u00c6\u0003J\t\u00103\u001a\u00020\bH\u00c6\u0003J\t\u00104\u001a\u00020\nH\u00c6\u0003J\t\u00105\u001a\u00020\fH\u00c6\u0003J\t\u00106\u001a\u00020\u000eH\u00c6\u0003J\t\u00107\u001a\u00020\u0010H\u00c6\u0003JY\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020=H\u00d6\u0001J\t\u0010>\u001a\u00020?H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0013\"\u0004\b#\u0010\u0015R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006@"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtContext2d$ContextState;", "", "strokeColor", "Ljava/awt/Color;", "fillColor", "stroke", "Ljava/awt/BasicStroke;", "textBaseline", "Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;", "textAlign", "Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "font", "Ljava/awt/Font;", "globalAlpha", "", "transform", "Ljava/awt/geom/AffineTransform;", "(Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/BasicStroke;Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;Lorg/jetbrains/letsPlot/core/canvas/TextAlign;Ljava/awt/Font;FLjava/awt/geom/AffineTransform;)V", "getFillColor", "()Ljava/awt/Color;", "setFillColor", "(Ljava/awt/Color;)V", "getFont", "()Ljava/awt/Font;", "setFont", "(Ljava/awt/Font;)V", "getGlobalAlpha", "()F", "setGlobalAlpha", "(F)V", "getStroke", "()Ljava/awt/BasicStroke;", "setStroke", "(Ljava/awt/BasicStroke;)V", "getStrokeColor", "setStrokeColor", "getTextAlign", "()Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "setTextAlign", "(Lorg/jetbrains/letsPlot/core/canvas/TextAlign;)V", "getTextBaseline", "()Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;", "setTextBaseline", "(Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;)V", "getTransform", "()Ljava/awt/geom/AffineTransform;", "setTransform", "(Ljava/awt/geom/AffineTransform;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "", "platf-awt"})
    public static final class ContextState {
        @NotNull
        private Color strokeColor;
        @NotNull
        private Color fillColor;
        @NotNull
        private BasicStroke stroke;
        @NotNull
        private TextBaseline textBaseline;
        @NotNull
        private TextAlign textAlign;
        @NotNull
        private java.awt.Font font;
        private float globalAlpha;
        @NotNull
        private AffineTransform transform;

        public ContextState(@NotNull Color strokeColor, @NotNull Color fillColor, @NotNull BasicStroke stroke, @NotNull TextBaseline textBaseline, @NotNull TextAlign textAlign, @NotNull java.awt.Font font, float globalAlpha, @NotNull AffineTransform transform) {
            Intrinsics.checkNotNullParameter((Object)strokeColor, (String)"strokeColor");
            Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
            Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
            Intrinsics.checkNotNullParameter((Object)textBaseline, (String)"textBaseline");
            Intrinsics.checkNotNullParameter((Object)textAlign, (String)"textAlign");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
            this.strokeColor = strokeColor;
            this.fillColor = fillColor;
            this.stroke = stroke;
            this.textBaseline = textBaseline;
            this.textAlign = textAlign;
            this.font = font;
            this.globalAlpha = globalAlpha;
            this.transform = transform;
        }

        public /* synthetic */ ContextState(Color color, Color color2, BasicStroke basicStroke, TextBaseline textBaseline, TextAlign textAlign, java.awt.Font font, float f, AffineTransform affineTransform, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Color color3 = Color.BLACK;
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"BLACK");
                color = color3;
            }
            if ((n & 2) != 0) {
                Color color4 = Color.BLACK;
                Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"BLACK");
                color2 = color4;
            }
            if ((n & 4) != 0) {
                basicStroke = new BasicStroke();
            }
            if ((n & 8) != 0) {
                textBaseline = TextBaseline.ALPHABETIC;
            }
            if ((n & 0x10) != 0) {
                textAlign = TextAlign.START;
            }
            if ((n & 0x20) != 0) {
                font = new java.awt.Font("Serif", 0, 10);
            }
            if ((n & 0x40) != 0) {
                f = 1.0f;
            }
            if ((n & 0x80) != 0) {
                affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            }
            this(color, color2, basicStroke, textBaseline, textAlign, font, f, affineTransform);
        }

        @NotNull
        public final Color getStrokeColor() {
            return this.strokeColor;
        }

        public final void setStrokeColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.strokeColor = color;
        }

        @NotNull
        public final Color getFillColor() {
            return this.fillColor;
        }

        public final void setFillColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.fillColor = color;
        }

        @NotNull
        public final BasicStroke getStroke() {
            return this.stroke;
        }

        public final void setStroke(@NotNull BasicStroke basicStroke) {
            Intrinsics.checkNotNullParameter((Object)basicStroke, (String)"<set-?>");
            this.stroke = basicStroke;
        }

        @NotNull
        public final TextBaseline getTextBaseline() {
            return this.textBaseline;
        }

        public final void setTextBaseline(@NotNull TextBaseline textBaseline) {
            Intrinsics.checkNotNullParameter((Object)textBaseline, (String)"<set-?>");
            this.textBaseline = textBaseline;
        }

        @NotNull
        public final TextAlign getTextAlign() {
            return this.textAlign;
        }

        public final void setTextAlign(@NotNull TextAlign textAlign) {
            Intrinsics.checkNotNullParameter((Object)textAlign, (String)"<set-?>");
            this.textAlign = textAlign;
        }

        @NotNull
        public final java.awt.Font getFont() {
            return this.font;
        }

        public final void setFont(@NotNull java.awt.Font font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
            this.font = font;
        }

        public final float getGlobalAlpha() {
            return this.globalAlpha;
        }

        public final void setGlobalAlpha(float f) {
            this.globalAlpha = f;
        }

        @NotNull
        public final AffineTransform getTransform() {
            return this.transform;
        }

        public final void setTransform(@NotNull AffineTransform affineTransform) {
            Intrinsics.checkNotNullParameter((Object)affineTransform, (String)"<set-?>");
            this.transform = affineTransform;
        }

        @NotNull
        public final Color component1() {
            return this.strokeColor;
        }

        @NotNull
        public final Color component2() {
            return this.fillColor;
        }

        @NotNull
        public final BasicStroke component3() {
            return this.stroke;
        }

        @NotNull
        public final TextBaseline component4() {
            return this.textBaseline;
        }

        @NotNull
        public final TextAlign component5() {
            return this.textAlign;
        }

        @NotNull
        public final java.awt.Font component6() {
            return this.font;
        }

        public final float component7() {
            return this.globalAlpha;
        }

        @NotNull
        public final AffineTransform component8() {
            return this.transform;
        }

        @NotNull
        public final ContextState copy(@NotNull Color strokeColor, @NotNull Color fillColor, @NotNull BasicStroke stroke, @NotNull TextBaseline textBaseline, @NotNull TextAlign textAlign, @NotNull java.awt.Font font, float globalAlpha, @NotNull AffineTransform transform) {
            Intrinsics.checkNotNullParameter((Object)strokeColor, (String)"strokeColor");
            Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
            Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
            Intrinsics.checkNotNullParameter((Object)textBaseline, (String)"textBaseline");
            Intrinsics.checkNotNullParameter((Object)textAlign, (String)"textAlign");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
            return new ContextState(strokeColor, fillColor, stroke, textBaseline, textAlign, font, globalAlpha, transform);
        }

        public static /* synthetic */ ContextState copy$default(ContextState contextState, Color color, Color color2, BasicStroke basicStroke, TextBaseline textBaseline, TextAlign textAlign, java.awt.Font font, float f, AffineTransform affineTransform, int n, Object object) {
            if ((n & 1) != 0) {
                color = contextState.strokeColor;
            }
            if ((n & 2) != 0) {
                color2 = contextState.fillColor;
            }
            if ((n & 4) != 0) {
                basicStroke = contextState.stroke;
            }
            if ((n & 8) != 0) {
                textBaseline = contextState.textBaseline;
            }
            if ((n & 0x10) != 0) {
                textAlign = contextState.textAlign;
            }
            if ((n & 0x20) != 0) {
                font = contextState.font;
            }
            if ((n & 0x40) != 0) {
                f = contextState.globalAlpha;
            }
            if ((n & 0x80) != 0) {
                affineTransform = contextState.transform;
            }
            return contextState.copy(color, color2, basicStroke, textBaseline, textAlign, font, f, affineTransform);
        }

        @NotNull
        public String toString() {
            return "ContextState(strokeColor=" + this.strokeColor + ", fillColor=" + this.fillColor + ", stroke=" + this.stroke + ", textBaseline=" + this.textBaseline + ", textAlign=" + this.textAlign + ", font=" + this.font + ", globalAlpha=" + this.globalAlpha + ", transform=" + this.transform + ')';
        }

        public int hashCode() {
            int result = this.strokeColor.hashCode();
            result = result * 31 + this.fillColor.hashCode();
            result = result * 31 + this.stroke.hashCode();
            result = result * 31 + this.textBaseline.hashCode();
            result = result * 31 + this.textAlign.hashCode();
            result = result * 31 + this.font.hashCode();
            result = result * 31 + Float.hashCode(this.globalAlpha);
            result = result * 31 + this.transform.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextState)) {
                return false;
            }
            ContextState contextState = (ContextState)other;
            if (!Intrinsics.areEqual((Object)this.strokeColor, (Object)contextState.strokeColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fillColor, (Object)contextState.fillColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stroke, (Object)contextState.stroke)) {
                return false;
            }
            if (this.textBaseline != contextState.textBaseline) {
                return false;
            }
            if (this.textAlign != contextState.textAlign) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.font, (Object)contextState.font)) {
                return false;
            }
            if (Float.compare(this.globalAlpha, contextState.globalAlpha) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.transform, (Object)contextState.transform);
        }

        public ContextState() {
            this(null, null, null, null, null, null, 0.0f, null, 255, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TextAlign.values().length];
            try {
                nArray[TextAlign.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextBaseline.values().length];
            try {
                nArray[TextBaseline.ALPHABETIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextBaseline.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextBaseline.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextBaseline.TOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

