/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalFunctions;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProvider;
import org.hamcrest.Description;

public class IsSameDay<T>
extends TemporalMatcher<T> {
    private final TemporalProvider<LocalDate> expected;
    private final TemporalConverter<T, LocalDate> converter;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsSameDay(TemporalConverter<T, LocalDate> converter, TemporalProvider<LocalDate> expected, Optional<ZoneId> zone, Locale locale) {
        this.expected = expected;
        this.converter = converter;
        this.locale = locale;
        this.zone = zone;
    }

    public IsSameDay(TemporalConverter<T, LocalDate> converter, TemporalProvider<LocalDate> expected) {
        this(converter, expected, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        LocalDate actualValue;
        LocalDate expectedValue = this.expected.apply(this.zone);
        if (!expectedValue.isEqual(actualValue = this.converter.apply(actual, this.zone))) {
            mismatchDescription.appendText("the day is " + this.describe(actualValue));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the same day as " + this.describe(this.expected.apply(this.zone)));
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsSameDay<T>(this.converter, this.expected, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsSameDay<T>(this.converter, this.expected, this.zone, locale);
    }

    private String describe(LocalDate actualValue) {
        return TemporalFunctions.LOCALDATE.describe(actualValue, this.locale);
    }
}

