/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.function;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.exparity.hamcrest.date.core.TemporalFunction;
import org.exparity.hamcrest.date.core.types.Interval;

public class ZonedDateTimeFunction
implements TemporalFunction<ZonedDateTime> {
    private static final String DATE_TIME_PATTERN = "EEE, dd MMM yyyy hh:mm:ss.SSS a Z";

    @Override
    public boolean isAfter(ZonedDateTime expected, ZonedDateTime actual) {
        return expected.isAfter(actual);
    }

    @Override
    public boolean isBefore(ZonedDateTime expected, ZonedDateTime actual) {
        return expected.isBefore(actual);
    }

    @Override
    public boolean isSame(ZonedDateTime expected, ZonedDateTime actual) {
        return expected.isEqual(actual);
    }

    @Override
    public Interval interval(ZonedDateTime expected, ZonedDateTime other, ChronoUnit unit) {
        return Interval.of(expected.until(other, unit), unit);
    }

    @Override
    public String describe(ZonedDateTime temporal, Locale locale) {
        return temporal.format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN, locale));
    }
}

