/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0006J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0006J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u000eJ\u001e\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTRNS;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "blue", "", "gray", "green", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "<set-?>", "", "palletteAlpha", "getPalletteAlpha", "()[I", "rGB", "getRGB", "rGB888", "getRGB888", "()I", "red", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "getGray", "parseFromRaw", "", "chunk", "setEntryPalAlpha", "idx", "val", "setGray", "g", "setIndexEntryAsTransparent", "palAlphaIndex", "setNentriesPalAlpha", "len", "setPalAlpha", "palAlpha", "setRGB", "r", "b", "Companion", "plot-api"})
public final class PngChunkTRNS
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int gray;
    private int red;
    private int green;
    private int blue;
    @NotNull
    private int[] palletteAlpha = new int[0];
    @NotNull
    public static final String ID = "tRNS";

    public PngChunkTRNS(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @NotNull
    public final int[] getPalletteAlpha() {
        return this.palletteAlpha;
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        ChunkRaw c = null;
        if (this.getImgInfo().getGreyscale()) {
            c = this.createEmptyChunk(2, true);
            byte[] byArray = c.getData();
            Intrinsics.checkNotNull((Object)byArray);
            PngHelperInternal.INSTANCE.writeInt2tobytes(this.gray, byArray, 0);
        } else if (this.getImgInfo().getIndexed()) {
            c = this.createEmptyChunk(this.palletteAlpha.length, true);
            int n = c.getLen();
            for (int n2 = 0; n2 < n; ++n2) {
                byte[] byArray = c.getData();
                Intrinsics.checkNotNull((Object)byArray);
                byArray[n2] = (byte)this.palletteAlpha[n2];
            }
        } else {
            c = this.createEmptyChunk(6, true);
            byte[] byArray = c.getData();
            Intrinsics.checkNotNull((Object)byArray);
            PngHelperInternal.INSTANCE.writeInt2tobytes(this.red, byArray, 0);
            byte[] byArray2 = c.getData();
            Intrinsics.checkNotNull((Object)byArray2);
            PngHelperInternal.INSTANCE.writeInt2tobytes(this.green, byArray2, 0);
            byte[] byArray3 = c.getData();
            Intrinsics.checkNotNull((Object)byArray3);
            PngHelperInternal.INSTANCE.writeInt2tobytes(this.blue, byArray3, 0);
        }
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (this.getImgInfo().getGreyscale()) {
            byte[] byArray = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray);
            this.gray = PngHelperInternal.INSTANCE.readInt2fromBytes(byArray, 0);
        } else if (this.getImgInfo().getIndexed()) {
            byte[] byArray = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray);
            int nentries = byArray.length;
            this.palletteAlpha = new int[nentries];
            for (int n = 0; n < nentries; ++n) {
                byte[] byArray2 = chunk.getData();
                Intrinsics.checkNotNull((Object)byArray2);
                this.palletteAlpha[n] = byArray2[n] & 0xFF;
            }
        } else {
            byte[] byArray = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray);
            this.red = PngHelperInternal.INSTANCE.readInt2fromBytes(byArray, 0);
            byte[] byArray3 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray3);
            this.green = PngHelperInternal.INSTANCE.readInt2fromBytes(byArray3, 2);
            byte[] byArray4 = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray4);
            this.blue = PngHelperInternal.INSTANCE.readInt2fromBytes(byArray4, 4);
        }
    }

    public final void setRGB(int r, int g, int b) {
        if (this.getImgInfo().getGreyscale() || this.getImgInfo().getIndexed()) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    @NotNull
    public final int[] getRGB() {
        if (this.getImgInfo().getGreyscale() || this.getImgInfo().getIndexed()) {
            throw new PngjException("only rgb or rgba images support this");
        }
        int[] nArray = new int[]{this.red, this.green, this.blue};
        return nArray;
    }

    public final int getRGB888() {
        if (this.getImgInfo().getGreyscale() || this.getImgInfo().getIndexed()) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return this.red << 16 | this.green << 8 | this.blue;
    }

    public final void setGray(int g) {
        if (!this.getImgInfo().getGreyscale()) {
            throw new PngjException("only grayscale images support this");
        }
        this.gray = g;
    }

    public final int getGray() {
        if (!this.getImgInfo().getGreyscale()) {
            throw new PngjException("only grayscale images support this");
        }
        return this.gray;
    }

    public final void setEntryPalAlpha(int idx, int val) {
        this.palletteAlpha[idx] = val;
    }

    public final void setNentriesPalAlpha(int len) {
        this.palletteAlpha = new int[len];
    }

    public final void setPalAlpha(@NotNull int[] palAlpha) {
        Intrinsics.checkNotNullParameter((Object)palAlpha, (String)"palAlpha");
        if (!this.getImgInfo().getIndexed()) {
            throw new PngjException("only indexed images support this");
        }
        this.palletteAlpha = palAlpha;
    }

    public final void setIndexEntryAsTransparent(int palAlphaIndex) {
        if (!this.getImgInfo().getIndexed()) {
            throw new PngjException("only indexed images support this");
        }
        int[] nArray = new int[]{palAlphaIndex + 1};
        this.palletteAlpha = nArray;
        for (int i = 0; i < palAlphaIndex; ++i) {
            this.palletteAlpha[i] = 255;
        }
        this.palletteAlpha[palAlphaIndex] = 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTRNS$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

