/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import sun.awt.SunToolkit;

public final class SwingUtil {
    private static final Logger LOGGER = LogUtil.getLogger(SwingUtil.class);
    private static final PaintSynthStyle PAINT_STYLE = new PaintSynthStyle();
    private static final SynthGraphicsUtils SYNTH_GRAPHICS_UTILS = new SynthGraphicsUtils();
    private static boolean swingInteropAvailable;

    private SwingUtil() {
    }

    public static void grab(Toolkit toolkit, Window window) {
        if (swingInteropAvailable) {
            try {
                Class.forName("jdk.swing.interop.SwingInterOpUtils").getMethod("grab", Toolkit.class, Window.class).invoke(null, toolkit, window);
            }
            catch (Throwable throwable) {}
        } else if (toolkit instanceof SunToolkit) {
            ((SunToolkit)toolkit).grab(window);
        }
    }

    public static void ungrab(Toolkit toolkit, Window window) {
        if (swingInteropAvailable) {
            try {
                Class.forName("jdk.swing.interop.SwingInterOpUtils").getMethod("ungrab", Toolkit.class, Window.class).invoke(null, toolkit, window);
            }
            catch (Throwable throwable) {}
        } else if (toolkit instanceof SunToolkit) {
            ((SunToolkit)toolkit).ungrab(window);
        }
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        FontMetrics fm = c.getFontMetrics(g.getFont());
        int adjustedY = y - fm.getAscent();
        SYNTH_GRAPHICS_UTILS.paintText(SwingUtil.createSynthContext(c), g, text, x, adjustedY, underlinedIndex);
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        SwingUtil.drawStringUnderlineCharAt(c, g, text, -1, x, y);
    }

    public static void setSkipClickCount(Component comp, int count) {
        UIUtilities.setSkipClickCount(comp, count);
    }

    public static int stringWidth(JComponent c, FontMetrics fm, String string) {
        return UIUtilities.stringWidth(c, fm, string);
    }

    public static String clipStringIfNecessary(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        return UIUtilities.clipStringIfNecessary(c, fm, string, availTextWidth);
    }

    public static int getFocusAcceleratorKeyMask() {
        if (SystemInfo.isMac) {
            return 10;
        }
        return 8;
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException("Graphics must not be null");
        }
        return SwingUtil.getFontMetrics(c, g.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent c, Font font) {
        if (c == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        if (font == null) {
            throw new IllegalArgumentException("Font must not be null");
        }
        return c.getFontMetrics(font);
    }

    public static boolean shouldIgnore(MouseEvent me, JComponent c) {
        return c == null || !c.isEnabled() || !SwingUtilities.isLeftMouseButton(me) || me.isConsumed();
    }

    public static void adjustFocus(JComponent c) {
        if (!c.hasFocus() && c.isRequestFocusEnabled()) {
            c.requestFocus();
        }
    }

    public static void compositeRequestFocus(Component component) {
        UIUtilities.compositeRequestFocus(component);
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel model, int lead, int anchor) {
        UIUtilities.setLeadAnchorWithoutSelection(model, lead, anchor);
    }

    public static boolean pointOutsidePrefSize(JTable table, int row, int column, Point p) {
        return UIUtilities.pointOutsidePrefSize(table, row, column, p);
    }

    public static boolean tabbedPaneChangeFocusTo(Component comp) {
        return UIUtilities.tabbedPaneChangeFocusTo(comp);
    }

    public static int loc2IndexFileList(JList<?> list, Point point) {
        return UIUtilities.loc2IndexFileList(list, point);
    }

    private static SynthContext createSynthContext(JComponent c) {
        return new SynthContext(c, Region.LABEL, PAINT_STYLE, 1024);
    }

    static {
        try {
            Class.forName("jdk.swing.interop.SwingInterOpUtils");
            swingInteropAvailable = true;
        }
        catch (Throwable e) {
            swingInteropAvailable = false;
        }
        LOGGER.fine("SwingInterOpUtils available: " + swingInteropAvailable);
    }

    private static class PaintSynthStyle
    extends SynthStyle {
        private PaintSynthStyle() {
        }

        @Override
        protected Color getColorForState(SynthContext context, ColorType type) {
            return null;
        }

        @Override
        protected Font getFontForState(SynthContext context) {
            return null;
        }
    }
}

