/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.inmemory.ConfigurationSettings;
import org.apache.chemistry.opencmis.inmemory.content.ObjectGenerator;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryService;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoreManagerFactory;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoreManagerImpl;
import org.apache.chemistry.opencmis.server.async.impl.AbstractAsyncServiceFactory;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.chemistry.opencmis.server.support.wrapper.ConformanceCmisServiceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryServiceFactoryImpl
extends AbstractAsyncServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)InMemoryServiceFactoryImpl.class.getName());
    private static final BigInteger DEFAULT_MAX_ITEMS_OBJECTS = BigInteger.valueOf(1000L);
    private static final BigInteger DEFAULT_MAX_ITEMS_TYPES = BigInteger.valueOf(100L);
    private static final BigInteger DEFAULT_DEPTH_OBJECTS = BigInteger.valueOf(2L);
    private static final BigInteger DEFAULT_DEPTH_TYPES = BigInteger.valueOf(-1L);
    private static CallContext overrideCtx;
    private boolean fUseOverrideCtx = false;
    private StoreManager storeManager;
    private CleanManager cleanManager = null;
    private File tempDir;
    private int memoryThreshold;
    private long maxContentSize;
    private boolean encrypt;

    public void init(Map<String, String> parameters) {
        Long cleanInterval;
        String tempDirStr;
        LOG.info("Initializing in-memory repository...");
        LOG.debug("Init paramaters: " + parameters);
        super.init(parameters);
        String overrideCtxParam = parameters.get("InMemoryServer.OverrideCallContext");
        if (null != overrideCtxParam) {
            this.fUseOverrideCtx = true;
        }
        ConfigurationSettings.init(parameters);
        String repositoryClassName = parameters.get("InMemoryServer.Class");
        if (null == repositoryClassName) {
            repositoryClassName = StoreManagerImpl.class.getName();
        }
        if (null == this.storeManager) {
            this.storeManager = StoreManagerFactory.createInstance(repositoryClassName);
        }
        this.tempDir = (tempDirStr = parameters.get("InMemoryServer.TempDir")) == null ? super.getTempDirectory() : new File(tempDirStr);
        String memoryThresholdStr = parameters.get("InMemoryServer.MemoryThreshold");
        this.memoryThreshold = memoryThresholdStr == null ? super.getMemoryThreshold() : Integer.parseInt(memoryThresholdStr);
        String maxContentSizeStr = parameters.get("InMemoryServer.MaxContentSize");
        this.maxContentSize = maxContentSizeStr == null ? super.getMaxContentSize() : Long.parseLong(maxContentSizeStr);
        String encryptTempFilesStr = parameters.get("InMemoryServer.EncryptTempFiles");
        this.encrypt = encryptTempFilesStr == null ? super.encryptTempFiles() : Boolean.parseBoolean(encryptTempFilesStr);
        Date deploymentTime = new Date();
        String strDate = new SimpleDateFormat("EEE MMM dd hh:mm:ss a z yyyy", Locale.US).format(deploymentTime);
        parameters.put("InMemoryServer.DeploymentTime", strDate);
        boolean created = this.initStorageManager(parameters);
        if (created) {
            this.fillRepositoryIfConfigured(parameters);
        }
        if (null != (cleanInterval = ConfigurationSettings.getConfigurationValueAsLong("InMemoryServer.CleanIntervalMinutes")) && cleanInterval > 0L) {
            this.scheduleCleanRepositoryJob(cleanInterval);
        }
        LOG.info("...initialized in-memory repository.");
    }

    public static void setOverrideCallContext(CallContext ctx) {
        overrideCtx = ctx;
    }

    public CmisService getService(CallContext context) {
        LOG.debug("start getService()");
        CallContext contextToUse = context;
        if (this.fUseOverrideCtx && null != overrideCtx) {
            contextToUse = overrideCtx;
        }
        LOG.debug("Creating new InMemoryService instance!");
        InMemoryService inMemoryService = new InMemoryService(this.storeManager, contextToUse);
        ConformanceCmisServiceWrapper wrapperService = new ConformanceCmisServiceWrapper((CmisService)inMemoryService, DEFAULT_MAX_ITEMS_TYPES, DEFAULT_DEPTH_TYPES, DEFAULT_MAX_ITEMS_OBJECTS, DEFAULT_DEPTH_OBJECTS);
        return inMemoryService;
    }

    public File getTempDirectory() {
        return this.tempDir;
    }

    public boolean encryptTempFiles() {
        return this.encrypt;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public long getMaxContentSize() {
        return this.maxContentSize;
    }

    public void destroy() {
        LOG.debug("Destroying InMemory service instance.");
        if (null != this.cleanManager) {
            this.cleanManager.stopCleanRepositoryJob();
        }
        super.destroy();
    }

    public StoreManager getStoreManger() {
        return this.storeManager;
    }

    private boolean initStorageManager(Map<String, String> parameters) {
        String typeDefsFileName;
        boolean created = false;
        String repositoryClassName = parameters.get("InMemoryServer.Class");
        if (null == repositoryClassName) {
            repositoryClassName = StoreManagerImpl.class.getName();
        }
        if (null == this.storeManager) {
            this.storeManager = StoreManagerFactory.createInstance(repositoryClassName);
        }
        String repositoryId = parameters.get("InMemoryServer.RepositoryId");
        List<String> allAvailableRepositories = this.storeManager.getAllRepositoryIds();
        for (String existingRepId : allAvailableRepositories) {
            this.storeManager.initRepository(existingRepId);
        }
        if (null != repositoryId) {
            if (allAvailableRepositories.contains(repositoryId)) {
                LOG.warn("Repostory " + repositoryId + " already exists and will not be created.");
            } else {
                String typeCreatorClassName = parameters.get("InMemoryServer.TypesCreatorClass");
                this.storeManager.createAndInitRepository(repositoryId, typeCreatorClassName);
                created = true;
            }
        }
        if (null == (typeDefsFileName = parameters.get("InMemoryServer.TypeDefinitionsFile"))) {
            LOG.info("No file name for type definitions given, no types will be created.");
        } else {
            TypeManager typeManager;
            TypeManager tmc = typeManager = this.storeManager.getTypeManager(repositoryId);
            this.importTypesFromFile(tmc, typeDefsFileName);
        }
        String parserMode = parameters.get("InMemoryServer.ParserMode");
        if (null != parserMode) {
            this.storeManager.addFlag(parserMode);
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importTypesFromFile(TypeManager tmc, String typeDefsFileName) {
        BufferedInputStream stream = null;
        TypeDefinition typeDef = null;
        File f = new File(typeDefsFileName);
        InputStream typesStream = null;
        if (!f.isFile()) {
            typesStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + typeDefsFileName);
        } else if (f.canRead()) {
            try {
                typesStream = new FileInputStream(f);
            }
            catch (Exception e) {
                LOG.error("Could not load type definitions from file '" + typeDefsFileName + "': " + e);
            }
        }
        if (typesStream == null) {
            LOG.warn("Resource file with type definitions " + typeDefsFileName + " could not be found, no types will be created.");
            return;
        }
        try {
            stream = new BufferedInputStream(typesStream);
            XMLStreamReader parser = XMLUtils.createParser((InputStream)stream);
            XMLUtils.findNextStartElemenet((XMLStreamReader)parser);
            while (true) {
                int event;
                if ((event = parser.getEventType()) == 1) {
                    QName name = parser.getName();
                    if (name.getLocalPart().equals("type")) {
                        typeDef = XMLConverter.convertTypeDefinition((XMLStreamReader)parser);
                        LOG.debug("Found type in file: " + typeDef.getLocalName());
                        if (typeDef.getPropertyDefinitions() == null) {
                            ((AbstractTypeDefinition)typeDef).setPropertyDefinitions(new LinkedHashMap());
                        }
                        tmc.addTypeDefinition(typeDef, true);
                    }
                    XMLUtils.next((XMLStreamReader)parser);
                    continue;
                }
                if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
            }
            parser.close();
        }
        catch (Exception e) {
            try {
                LOG.error("Could not load type definitions from file '" + typeDefsFileName + "': " + e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)stream);
        }
        IOUtils.closeQuietly((Closeable)stream);
    }

    private static List<String> readPropertiesToSetFromConfig(Map<String, String> parameters, String keyPrefix) {
        String propertyKey;
        String propertyToAdd;
        ArrayList<String> propsToSet = new ArrayList<String>();
        int i = 0;
        while (null != (propertyToAdd = parameters.get(propertyKey = keyPrefix + Integer.toString(i)))) {
            propsToSet.add(propertyToAdd);
            ++i;
        }
        return propsToSet;
    }

    private void fillRepositoryIfConfigured(Map<String, String> parameters) {
        String repositoryId = parameters.get("InMemoryServer.RepositoryId");
        String doFillRepositoryStr = parameters.get("RepositoryFiller.Enable");
        String contentKindStr = parameters.get("RepositoryFiller.ContentKind");
        boolean doFillRepository = doFillRepositoryStr == null ? false : Boolean.parseBoolean(doFillRepositoryStr);
        class DummyCallContext
        implements CallContext {
            DummyCallContext() {
            }

            public String get(String key) {
                return null;
            }

            public String getBinding() {
                return null;
            }

            public boolean isObjectInfoRequired() {
                return false;
            }

            public CmisVersion getCmisVersion() {
                return CmisVersion.CMIS_1_1;
            }

            public String getRepositoryId() {
                return null;
            }

            public String getLocale() {
                return null;
            }

            public BigInteger getOffset() {
                return null;
            }

            public BigInteger getLength() {
                return null;
            }

            public String getPassword() {
                return null;
            }

            public String getUsername() {
                return null;
            }

            public File getTempDirectory() {
                return InMemoryServiceFactoryImpl.this.tempDir;
            }

            public boolean encryptTempFiles() {
                return InMemoryServiceFactoryImpl.this.encrypt;
            }

            public int getMemoryThreshold() {
                return InMemoryServiceFactoryImpl.this.memoryThreshold;
            }

            public long getMaxContentSize() {
                return InMemoryServiceFactoryImpl.this.maxContentSize;
            }
        }
        DummyCallContext ctx = new DummyCallContext();
        if (doFillRepository) {
            String folderTypeId;
            String documentTypeId;
            InMemoryService svc = new InMemoryService(this.storeManager, ctx);
            BindingsObjectFactoryImpl objectFactory = new BindingsObjectFactoryImpl();
            String levelsStr = parameters.get("RepositoryFiller.Depth");
            int levels = 1;
            if (null != levelsStr) {
                levels = Integer.parseInt(levelsStr);
            }
            String docsPerLevelStr = parameters.get("RepositoryFiller.DocsPerFolder");
            int docsPerLevel = 1;
            if (null != docsPerLevelStr) {
                docsPerLevel = Integer.parseInt(docsPerLevelStr);
            }
            String childrenPerLevelStr = parameters.get("RepositoryFiller.FolderPerFolder");
            int childrenPerLevel = 2;
            if (null != childrenPerLevelStr) {
                childrenPerLevel = Integer.parseInt(childrenPerLevelStr);
            }
            if (null == (documentTypeId = parameters.get("RepositoryFiller.DocumentTypeId"))) {
                documentTypeId = BaseTypeId.CMIS_DOCUMENT.value();
            }
            if (null == (folderTypeId = parameters.get("RepositoryFiller.FolderTypeId"))) {
                folderTypeId = BaseTypeId.CMIS_FOLDER.value();
            }
            int contentSizeKB = 0;
            String contentSizeKBStr = parameters.get("RepositoryFiller.ContentSizeInKB");
            if (null != contentSizeKBStr) {
                contentSizeKB = Integer.parseInt(contentSizeKBStr);
            }
            ObjectGenerator.ContentKind contentKind = null == contentKindStr ? ObjectGenerator.ContentKind.LOREM_IPSUM_TEXT : (contentKindStr.equals("static/text") ? ObjectGenerator.ContentKind.STATIC_TEXT : (contentKindStr.equals("lorem/text") ? ObjectGenerator.ContentKind.LOREM_IPSUM_TEXT : (contentKindStr.equals("lorem/html") ? ObjectGenerator.ContentKind.LOREM_IPSUM_HTML : (contentKindStr.equals("fractal/jpeg") ? ObjectGenerator.ContentKind.IMAGE_FRACTAL_JPEG : ObjectGenerator.ContentKind.STATIC_TEXT))));
            ObjectGenerator gen = new ObjectGenerator((BindingsObjectFactory)objectFactory, (NavigationService)svc, (ObjectService)svc, (RepositoryService)svc, repositoryId, contentKind);
            gen.setNumberOfDocumentsToCreatePerFolder(docsPerLevel);
            gen.setDocumentTypeId(documentTypeId);
            gen.setFolderTypeId(folderTypeId);
            gen.setContentSizeInKB(contentSizeKB);
            List<String> propsToSet = InMemoryServiceFactoryImpl.readPropertiesToSetFromConfig(parameters, "RepositoryFiller.DocumentProperty.");
            if (null != propsToSet) {
                gen.setDocumentPropertiesToGenerate(propsToSet);
            }
            if (null != (propsToSet = InMemoryServiceFactoryImpl.readPropertiesToSetFromConfig(parameters, "RepositoryFiller.FolderProperty."))) {
                gen.setFolderPropertiesToGenerate(propsToSet);
            }
            this.getService(ctx);
            RepositoryInfo rep = svc.getRepositoryInfo(repositoryId, null);
            String rootFolderId = rep.getRootFolderId();
            try {
                gen.createFolderHierachy(levels, childrenPerLevel, rootFolderId);
                gen.dumpFolder(rootFolderId, "*");
            }
            catch (Exception e) {
                LOG.error("Could not create folder hierarchy with documents. ", (Throwable)e);
            }
            svc.close();
        }
    }

    private void scheduleCleanRepositoryJob(long minutes) {
        this.cleanManager = new CleanManager();
        this.cleanManager.startCleanRepositoryJob(minutes);
    }

    class CleanManager {
        private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        private ScheduledFuture<?> cleanerHandle = null;

        CleanManager() {
        }

        public void startCleanRepositoryJob(long intervalInMinutes) {
            Runnable cleaner = new Runnable(){

                @Override
                public void run() {
                    LOG.info("Cleaning repository as part of a scheduled maintenance job.");
                    for (String repositoryId : InMemoryServiceFactoryImpl.this.storeManager.getAllRepositoryIds()) {
                        ObjectStore store = InMemoryServiceFactoryImpl.this.storeManager.getObjectStore(repositoryId);
                        store.clear();
                        InMemoryServiceFactoryImpl.this.fillRepositoryIfConfigured(ConfigurationSettings.getParameters());
                    }
                    LOG.info("Repository cleaned. Freeing memory.");
                    System.gc();
                }
            };
            LOG.info("Repository Clean Job starting clean job, interval " + intervalInMinutes + " min");
            this.cleanerHandle = this.scheduler.scheduleAtFixedRate(cleaner, intervalInMinutes, intervalInMinutes, TimeUnit.MINUTES);
        }

        public void stopCleanRepositoryJob() {
            LOG.info("Repository Clean Job cancelling clean job.");
            boolean ok = this.cleanerHandle.cancel(true);
            LOG.info("Repository Clean Job cancelled with result: " + ok);
            this.scheduler.shutdownNow();
        }
    }
}

